/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.topic;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import simpletree.datamining.clustering.BKmeans;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.projectioncloud.projection.Projector;
import simpletree.projectioncloud.topic.Term;

public class GraphTopic {
    private AbstractMatrix matrix;

    public GraphTopic(AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public ArrayList<Term> create(ArrayList<Integer> cluster, int nrterms) throws IOException {
        AbstractMatrix auxmat = MatrixFactory.getInstance(this.matrix.getClass());
        for (int i = 0; i < cluster.size(); ++i) {
            auxmat.addRow(this.matrix.getRow(cluster.get(i)));
        }
        float[][] points = auxmat.toMatrix();
        ArrayList<String> newAttributes = new ArrayList<String>();
        points = this.reduceMatrix(points, 200, newAttributes);
        int size = points[0].length;
        int pivot1 = 0;
        int pivot2 = 0;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float cov;
                if (i == j || !(max < (cov = this.covariance(points, i, j)))) continue;
                max = cov;
                pivot1 = i;
                pivot2 = j;
            }
        }
        float covt1 = 0.0f;
        float covt2 = 0.0f;
        for (int i = 0; i < size; ++i) {
            covt1 += this.covariance(points, pivot1, i);
            covt2 += this.covariance(points, pivot2, i);
        }
        int pivot = covt1 > covt2 ? pivot1 : pivot2;
        System.out.println("PIVOT= " + newAttributes.get(pivot));
        DoubleMatrix2D covmat = this.createLaplacianMatrix(points);
        SingularValueDecomposition svd = new SingularValueDecomposition(covmat);
        double[] eignvect = svd.getU().viewColumn(points[0].length - 2).toArray();
        ArrayList<Pair> seq = new ArrayList<Pair>();
        for (int i = 0; i < eignvect.length; ++i) {
            float diff = (float)Math.abs(Math.abs(eignvect[pivot]) - Math.abs(eignvect[i]));
            seq.add(new Pair(i, 1.0f / (1.0f + diff) * this.covariance(points, pivot, i)));
        }
        Collections.sort(seq);
        ArrayList<Term> topic = new ArrayList<Term>();
        for (int i = 0; i < Math.min(nrterms, seq.size()); ++i) {
            if (!(((Pair)seq.get((int)i)).freq >= ((Pair)seq.get((int)0)).freq * 0.001f)) continue;
            Term t = new Term(newAttributes.get(((Pair)seq.get((int)i)).index), ((Pair)seq.get((int)i)).freq);
            topic.add(t);
        }
        System.out.println("######");
        System.out.println("Number documents: " + points.length);
        for (Term t : topic) {
            System.out.print(t.term + "<>" + t.weight + ";");
        }
        System.out.println();
        return topic;
    }

    private DoubleMatrix2D createLaplacianMatrix(float[][] points) {
        int j;
        int i;
        int size = points[0].length;
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(size, size);
        int nrneighbors = 10;
        for (i = 0; i < size; ++i) {
            ArrayList<Pair> covs = new ArrayList<Pair>();
            for (j = 0; j < size; ++j) {
                if (i == j) continue;
                float cov = this.covariance(points, i, j);
                covs.add(new Pair(j, cov));
            }
            Collections.sort(covs);
            for (j = 0; j < nrneighbors; ++j) {
                mat.setQuick(i, ((Pair)covs.get((int)j)).index, (double)((Pair)covs.get((int)j)).freq);
            }
        }
        this.fullconnect(points, mat);
        for (i = 0; i < size; ++i) {
            float diag = 0.0f;
            for (j = 0; j < size; ++j) {
                diag = (float)((double)diag + mat.getQuick(i, j));
            }
            mat.setQuick(i, i, (double)(-diag));
        }
        return mat;
    }

    private void fullconnect(float[][] points, DenseDoubleMatrix2D mat) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (int i = 0; i < mat.rows(); ++i) {
            indexes.add(i);
        }
        HashSet<Integer> removed = new HashSet<Integer>();
        this.fullconnect_aux(mat, 0, removed, indexes);
        while (!indexes.isEmpty()) {
            Iterator<Integer> it1 = indexes.iterator();
            int index1 = 0;
            int index2 = 0;
            float max = Float.NEGATIVE_INFINITY;
            while (it1.hasNext()) {
                int id1 = it1.next();
                for (int id2 : removed) {
                    float cov = this.covariance(points, id1, id2);
                    if (!(max < cov)) continue;
                    max = cov;
                    index1 = id1;
                    index2 = id2;
                }
            }
            mat.setQuick(index1, index2, (double)this.covariance(points, index1, index2));
            mat.setQuick(index2, index1, (double)this.covariance(points, index1, index2));
            this.fullconnect_aux(mat, index1, removed, indexes);
        }
    }

    private void fullconnect_aux(DenseDoubleMatrix2D mat, int toremove, HashSet<Integer> removed, HashSet<Integer> indexes) {
        boolean rem = indexes.remove(toremove);
        if (rem) {
            double[] array = mat.viewRow(toremove).toArray();
            for (int i = 0; i < array.length; ++i) {
                if (!(Math.abs(array[i]) > (double)1.0E-6f)) continue;
                removed.add(i);
                this.fullconnect_aux(mat, i, removed, indexes);
            }
        }
    }

    private float covariance(float[][] points, int a, int b) {
        float amean = 0.0f;
        float bmean = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            amean += points[i][a];
            bmean += points[i][b];
        }
        amean /= (float)points.length;
        bmean /= (float)points.length;
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += (points[i][a] - amean) * (points[i][b] - bmean);
        }
        return covariance /= (float)(points.length - 1);
    }

    private float[][] reduceMatrix(float[][] points, int nrdim, ArrayList<String> newAttributes) {
        int i;
        ArrayList<String> attr = this.matrix.getAttributes();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (int j = 0; j < points[0].length; ++j) {
            float freq = 0.0f;
            for (int i2 = 0; i2 < points.length; ++i2) {
                freq += points[i2][j];
            }
            pairs.add(new Pair(j, freq));
        }
        Collections.sort(pairs);
        float[][] newpoints = new float[points.length][];
        for (i = 0; i < points.length; ++i) {
            newpoints[i] = new float[points[i].length < nrdim ? points[i].length : nrdim];
            for (int j = 0; j < newpoints[i].length; ++j) {
                newpoints[i][j] = points[i][((Pair)pairs.get((int)j)).index];
            }
        }
        for (i = 0; i < newpoints[0].length; ++i) {
            newAttributes.add(attr.get(((Pair)pairs.get((int)i)).index));
        }
        return newpoints;
    }

    public static void main(String[] args) throws IOException {
        String filenametfidf = "rssnewsfeeds_tfidf.data";
        AbstractMatrix matrixtfidf = MatrixFactory.getInstance(filenametfidf);
        String filenametf = "rssnewsfeeds_tf.data";
        AbstractMatrix matrixtf = MatrixFactory.getInstance(filenametf);
        Projector p = new Projector();
        AbstractMatrix proj = p.execute(matrixtfidf);
        BKmeans kmeans = new BKmeans(12);
        ArrayList<ArrayList<Integer>> clusters = kmeans.execute(new Euclidean(), proj);
        for (int i = 0; i < clusters.size(); ++i) {
            GraphTopic gt = new GraphTopic(matrixtf);
            ArrayList<Term> terms = gt.create(clusters.get(i), 20);
            for (Term t : terms) {
                System.out.print(t.term + ";");
            }
            System.out.println();
        }
    }

    public static class Pair
    implements Comparable {
        public int index;
        public float freq;

        public Pair(int index, float freq) {
            this.index = index;
            this.freq = freq;
        }

        public int compareTo(Object o) {
            float diff = ((Pair)o).freq - this.freq;
            return diff == 0.0f ? 0 : (diff > 0.0f ? 1 : -1);
        }
    }
}

