/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import simpletree.projectioncloud.fill.Group;
import simpletree.projectioncloud.topic.Term;

public class PolygonFill
extends JFrame {
    public PolygonFill() throws IOException {
        this.setSize(1000, 1000);
        this.setDefaultCloseOperation(3);
        Painel p = new Painel();
        p.execute();
        this.getContentPane().add(p);
        this.addKeyListener(p);
    }

    public static void main(String[] args) throws IOException {
        PolygonFill pf = new PolygonFill();
        pf.setVisible(true);
    }

    public class Painel
    extends JPanel
    implements MouseListener,
    KeyListener {
        private Group group;
        private Polygon pol;
        private BufferedImage image;

        public Painel() throws IOException {
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }

        public final void execute() throws IOException {
            this.pol = new Polygon();
            this.group = new Group(new ArrayList<Integer>());
            ArrayList<Term> terms = new ArrayList<Term>();
            Random rand = new Random(7L);
            for (int i = 0; i < 200; ++i) {
                int r = rand.nextInt(200);
                terms.add(new Term("flower", r * r * r * r));
            }
            this.group.setTerms(terms);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.pol.addPoint(e.getX(), e.getY());
            this.image = new BufferedImage(1000, 1000, 2);
            ((Graphics2D)this.image.getGraphics()).draw(this.pol);
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.group.setPolygon(this.pol);
            this.group.fillPolygon();
            this.image = new BufferedImage(1000, 1000, 2);
            ((Graphics2D)this.image.getGraphics()).draw(this.pol);
            this.group.draw(this.image, true);
            this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

