/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.projectioncloud.projection.ProjectionPolygonModel;
import simpletree.projectioncloud.projection.Projector;
import simpletree.textprocessing.corpus.zip.ZipCorpus;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.Stopword;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;
import simpletree.textprocessing.processing.transformation.MatrixTransformationFactory;
import simpletree.view.ProjectionFrame;

public class UserManipulation {
    public static void main(String[] args) throws IOException {
        String stpfilename = "C:\\Users\\paulovich\\Documents\\corpora\\stopwords_infovis04.spw";
        String corpusfilename = "C:\\Users\\paulovich\\Documents\\corpora\\Infovis04_all.zip";
        int lowercut = 25;
        int uppercut = -1;
        int nrclusters = 12;
        Stopword stp = Stopword.getInstance();
        stp.changeStopwordList(stpfilename);
        ZipCorpus corpus = new ZipCorpus(corpusfilename, 1);
        Preprocessor preproc = new Preprocessor(corpus);
        AbstractMatrix matrixtf = preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.NONE);
        MatrixTransformation mt = MatrixTransformationFactory.getInstance(MatrixTransformationFactory.MatrixTransformationType.TF_IDF);
        AbstractMatrix matrixtfidf = mt.tranform(preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.PORTER), null);
        Projector p = new Projector();
        AbstractMatrix proj = p.execute(matrixtfidf);
        ProjectionPolygonModel model = new ProjectionPolygonModel();
        Scalar cdata = model.addScalar("cdata");
        Scalar dots = model.addScalar("...");
        int nrows = proj.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            AbstractVector row = proj.getRow(i);
            ProjectionInstance pi = new ProjectionInstance(row.getId(), row.getValue(0), row.getValue(1));
            model.addInstance(pi);
            pi.setScalarValue(cdata, row.getKlass());
            pi.setScalarValue(dots, 0.0f);
        }
        ArrayList<Integer> cluster = new ArrayList<Integer>();
        cluster.add(UserManipulation.map(-1834871703, proj));
        cluster.add(UserManipulation.map(-1018060726, proj));
        cluster.add(UserManipulation.map(-1495353366, proj));
        cluster.add(UserManipulation.map(-1493506324, proj));
        cluster.add(UserManipulation.map(-1017137205, proj));
        cluster.add(UserManipulation.map(-1464877173, proj));
        cluster.add(UserManipulation.map(-1374372115, proj));
        cluster.add(UserManipulation.map(-1351284090, proj));
        cluster.add(UserManipulation.map(-1318037334, proj));
        cluster.add(UserManipulation.map(-1315266771, proj));
        cluster.add(UserManipulation.map(-1292178746, proj));
        cluster.add(UserManipulation.map(-1291255225, proj));
        cluster.add(UserManipulation.map(-1290331704, proj));
        cluster.add(UserManipulation.map(-1288484662, proj));
        cluster.add(UserManipulation.map(-1287561141, proj));
        cluster.add(UserManipulation.map(-1286637620, proj));
        cluster.add(UserManipulation.map(-1266320158, proj));
        cluster.add(UserManipulation.map(-1265396637, proj));
        cluster.add(UserManipulation.map(-1236767486, proj));
        cluster.add(UserManipulation.map(-1233996923, proj));
        cluster.add(UserManipulation.map(-603232080, proj));
        cluster.add(UserManipulation.map(-600461517, proj));
        cluster.add(UserManipulation.map(-579220534, proj));
        cluster.add(UserManipulation.map(-578297013, proj));
        cluster.add(UserManipulation.map(-577373492, proj));
        cluster.add(UserManipulation.map(-576449971, proj));
        cluster.add(UserManipulation.map(-575526450, proj));
        cluster.add(UserManipulation.map(-574602929, proj));
        cluster.add(UserManipulation.map(-573679408, proj));
        cluster.add(UserManipulation.map(-570908845, proj));
        cluster.add(UserManipulation.map(-987584533, proj));
        cluster.add(UserManipulation.map(-545050257, proj));
        cluster.add(UserManipulation.map(-544126736, proj));
        cluster.add(UserManipulation.map(-543203215, proj));
        cluster.add(UserManipulation.map(-542279694, proj));
        cluster.add(UserManipulation.map(-521962232, proj));
        cluster.add(UserManipulation.map(-461933367, proj));
        cluster.add(UserManipulation.map(-434227737, proj));
        cluster.add(UserManipulation.map(-433304216, proj));
        cluster.add(UserManipulation.map(-432380695, proj));
        cluster.add(UserManipulation.map(-404675065, proj));
        cluster.add(UserManipulation.map(-400057460, proj));
        cluster.add(UserManipulation.map(-374198872, proj));
        cluster.add(UserManipulation.map(-370504788, proj));
        cluster.add(UserManipulation.map(-981119886, proj));
        cluster.add(UserManipulation.map(285195122, proj));
        cluster.add(UserManipulation.map(286118643, proj));
        cluster.add(UserManipulation.map(309206668, proj));
        cluster.add(UserManipulation.map(310130189, proj));
        cluster.add(UserManipulation.map(312900752, proj));
        cluster.add(UserManipulation.map(336912298, proj));
        cluster.add(UserManipulation.map(337835819, proj));
        cluster.add(UserManipulation.map(340606382, proj));
        cluster.add(UserManipulation.map(344300466, proj));
        cluster.add(UserManipulation.map(368312012, proj));
        cluster.add(UserManipulation.map(369235533, proj));
        cluster.add(UserManipulation.map(394170600, proj));
        cluster.add(UserManipulation.map(-956184819, proj));
        cluster.add(UserManipulation.map(430187919, proj));
        cluster.add(UserManipulation.map(455122986, proj));
        cluster.add(UserManipulation.map(456970028, proj));
        cluster.add(UserManipulation.map(481905095, proj));
        cluster.add(UserManipulation.map(482828616, proj));
        cluster.add(UserManipulation.map(488369742, proj));
        cluster.add(UserManipulation.map(508687204, proj));
        cluster.add(UserManipulation.map(509610725, proj));
        cluster.add(UserManipulation.map(537316355, proj));
        cluster.add(UserManipulation.map(541933960, proj));
        cluster.add(UserManipulation.map(1167157677, proj));
        cluster.add(UserManipulation.map(1168081198, proj));
        cluster.add(UserManipulation.map(1171775282, proj));
        cluster.add(UserManipulation.map(1200404433, proj));
        cluster.add(UserManipulation.map(1201327954, proj));
        cluster.add(UserManipulation.map(-930326231, proj));
        cluster.add(UserManipulation.map(1225339500, proj));
        cluster.add(UserManipulation.map(1231804147, proj));
        cluster.add(UserManipulation.map(-929402710, proj));
        cluster.add(UserManipulation.map(1258586256, proj));
        cluster.add(UserManipulation.map(1259509777, proj));
        cluster.add(UserManipulation.map(-928479189, proj));
        cluster.add(UserManipulation.map(1281674281, proj));
        cluster.add(UserManipulation.map(1286291886, proj));
        cluster.add(UserManipulation.map(1287215407, proj));
        cluster.add(UserManipulation.map(-927555668, proj));
        cluster.add(UserManipulation.map(1314921037, proj));
        cluster.add(UserManipulation.map(1315844558, proj));
        cluster.add(UserManipulation.map(1318615121, proj));
        cluster.add(UserManipulation.map(1342626667, proj));
        cluster.add(UserManipulation.map(1369408776, proj));
        cluster.add(UserManipulation.map(1370332297, proj));
        cluster.add(UserManipulation.map(1371255818, proj));
        cluster.add(UserManipulation.map(-924785105, proj));
        cluster.add(UserManipulation.map(1398961448, proj));
        cluster.add(UserManipulation.map(1403579053, proj));
        cluster.add(UserManipulation.map(1430361162, proj));
        cluster.add(UserManipulation.map(2055584879, proj));
        cluster.add(UserManipulation.map(-901697080, proj));
        cluster.add(UserManipulation.map(2118384307, proj));
        cluster.add(UserManipulation.map(2145166416, proj));
        cluster.add(UserManipulation.map(2146089937, proj));
        cluster.add(UserManipulation.map(-2090695536, proj));
        cluster.add(UserManipulation.map(-898002996, proj));
        cluster.add(UserManipulation.map(-2065760469, proj));
        cluster.add(UserManipulation.map(-2062989906, proj));
        cluster.add(UserManipulation.map(-2062066385, proj));
        cluster.add(UserManipulation.map(-2039901881, proj));
        cluster.add(UserManipulation.map(-2008502167, proj));
        cluster.add(UserManipulation.map(-2005731604, proj));
        cluster.add(UserManipulation.map(-2003884562, proj));
        cluster.add(UserManipulation.map(-1982643579, proj));
        cluster.add(UserManipulation.map(-1978025974, proj));
        cluster.add(UserManipulation.map(-1976178932, proj));
        cluster.add(UserManipulation.map(-1345414089, proj));
        cluster.add(UserManipulation.map(-1324173106, proj));
        cluster.add(UserManipulation.map(-1323249585, proj));
        cluster.add(UserManipulation.map(-869373845, proj));
        cluster.add(UserManipulation.map(-845362299, proj));
        cluster.add(UserManipulation.map(-816733148, proj));
        cluster.add(UserManipulation.map(-809344980, proj));
        cluster.add(UserManipulation.map(-788103997, proj));
        cluster.add(UserManipulation.map(-782562871, proj));
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        clusters.add(cluster);
        model.setClusters(clusters);
        model.createTopics(matrixtf);
        ProjectionFrame frame = new ProjectionFrame();
        frame.setSize(1200, 1200);
        frame.setModel(model);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    public static int map(int id, AbstractMatrix matrix) {
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            if (matrix.getRow(i).getId() != id) continue;
            return i;
        }
        return -1;
    }
}

