/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.clustering.BKmeans;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.projectioncloud.projection.Projector;
import simpletree.textprocessing.corpus.zip.ZipCorpus;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.Stopword;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;
import simpletree.textprocessing.processing.transformation.MatrixTransformationFactory;

public class Util {
    private static BufferedImage image = new BufferedImage(400, 200, 1);

    public static float calcArea(Polygon polygon) {
        int sum = 0;
        for (int i = 0; i < polygon.npoints - 1; ++i) {
            sum += polygon.xpoints[i] * polygon.ypoints[i + 1] - polygon.ypoints[i] * polygon.xpoints[i + 1];
        }
        return Math.abs((float)sum / 2.0f);
    }

    public static Dimension getSize(String str, Font font) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        FontMetrics metrics = g2.getFontMetrics(font);
        int hgt = metrics.getHeight();
        int adv = metrics.stringWidth(str);
        return new Dimension(adv, hgt / 2 + 2);
    }

    public static Dimension getSizeExact(String str, Font font) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2.setColor(Color.BLACK);
        g2.setFont(font);
        g2.drawString(str, 10, (int)((float)image.getHeight() * 0.75f));
        int width = image.getWidth();
        int height = image.getHeight();
        int rgbback = Color.WHITE.getRGB();
        int startx = width;
        int starty = height;
        int endx = 0;
        int endy = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int rgb = image.getRGB(j, i);
                if (rgb == rgbback) continue;
                startx = Math.min(startx, j);
                starty = Math.min(starty, i);
                endx = Math.max(endx, j);
                endy = Math.max(endy, i);
            }
        }
        return new Dimension(endx - startx + 4, endy - starty + 4);
    }

    public static BufferedImage trim(BufferedImage image, Color background) {
        int width = image.getWidth();
        int height = image.getHeight();
        int rgbback = background.getRGB();
        int startx = width;
        int starty = height;
        int endx = 0;
        int endy = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int rgb = image.getRGB(j, i);
                if (rgb == rgbback) continue;
                startx = Math.min(startx, j);
                starty = Math.min(starty, i);
                endx = Math.max(endx, j);
                endy = Math.max(endy, i);
            }
        }
        startx = startx - 2 > 0 ? startx - 2 : 0;
        starty = starty - 2 > 0 ? starty - 2 : 0;
        endx = endx + 2 < width ? endx + 2 : width - 1;
        endy = endy + 2 < height ? endy + 2 : height - 1;
        return image.getSubimage(startx, starty, endx - startx, endy - starty);
    }

    public static void createWordle() throws IOException {
        String stpfilename = "C:\\Users\\paulovich\\Documents\\corpora\\stopwords_infovis04.spw";
        String corpusfilename = "C:\\Users\\paulovich\\Documents\\corpora\\Infovis04_all.zip";
        int lowercut = 25;
        int uppercut = -1;
        Stopword stp = Stopword.getInstance();
        stp.changeStopwordList(stpfilename);
        ZipCorpus corpus = new ZipCorpus(corpusfilename, 1);
        Preprocessor preproc = new Preprocessor(corpus);
        AbstractMatrix matrixtf = preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.NONE);
        ArrayList<String> attr = matrixtf.getAttributes();
        float[][] mat = matrixtf.toMatrix();
        for (int i = 0; i < attr.size(); ++i) {
            System.out.print(attr.get(i) + ":");
            int freq = 0;
            for (int j = 0; j < mat.length; ++j) {
                freq = (int)((float)freq + mat[j][i]);
            }
            System.out.println(freq);
        }
    }

    public static void createWordleCluster() throws IOException {
        String stpfilename = "C:\\Users\\paulovich\\Documents\\corpora\\stopwords_news.spw";
        String corpusfilename = "C:\\Users\\paulovich\\Documents\\corpora\\rssnewsfeeds.zip";
        int lowercut = 25;
        int uppercut = -1;
        int nrclusters = 12;
        Stopword stp = Stopword.getInstance();
        stp.changeStopwordList(stpfilename);
        ZipCorpus corpus = new ZipCorpus(corpusfilename, 1);
        Preprocessor preproc = new Preprocessor(corpus);
        AbstractMatrix matrixtf = preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.NONE);
        MatrixTransformation mt = MatrixTransformationFactory.getInstance(MatrixTransformationFactory.MatrixTransformationType.TF_IDF);
        AbstractMatrix matrixtfidf = mt.tranform(preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.PORTER), null);
        Projector p = new Projector();
        AbstractMatrix proj = p.execute(matrixtfidf);
        BKmeans kmeans = new BKmeans(nrclusters);
        ArrayList<ArrayList<Integer>> clusters = kmeans.execute(new Euclidean(), proj);
        ArrayList<String> attr = matrixtf.getAttributes();
        float[][] mat = matrixtf.toMatrix();
        for (int i = 0; i < clusters.size(); ++i) {
            System.out.println("############# Cluster #############");
            for (int j = 0; j < attr.size(); ++j) {
                int freq = 0;
                for (int k = 0; k < clusters.get(i).size(); ++k) {
                    freq = (int)((float)freq + mat[clusters.get(i).get(k)][j]);
                }
                if (freq <= 10) continue;
                System.out.println(attr.get(j) + ":" + freq);
            }
            System.out.println("############# Cluster #############");
        }
    }

    public static void main(String[] args) throws IOException {
        Util.createWordleCluster();
    }
}

