/*
 * Decompiled with CFR 0.152.
 */
package simpletree.simpletree.view.tools.correlation;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DetailedDistanceMatrix;
import simpletree.distance.DistanceMatrix;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.TreeDistanceCalculator;

public class SimpleTreeCorrelationCoefficient {
    public String execute(DistanceMatrix dmat, ArrayList<SimpleTreeModel> models, ArrayList<DetailedDistanceMatrix> projectionDmats) throws IOException {
        int i;
        String result = "";
        ArrayList<float[]> distanceVectorsO = new ArrayList<float[]>();
        ArrayList<float[]> distanceVectorsP = new ArrayList<float[]>();
        for (i = 0; i < dmat.getElementCount(); ++i) {
            distanceVectorsO.add(new float[dmat.getElementCount()]);
            for (int k = 0; k < dmat.getElementCount(); ++k) {
                ((float[])distanceVectorsO.get((int)i))[k] = dmat.getDistance(i, k);
            }
        }
        if (models != null && !models.isEmpty()) {
            for (i = 0; i < models.size(); ++i) {
                SimpleTreeModel model = models.get(i);
                distanceVectorsP = new ArrayList();
                for (int j = 0; j < model.getValidInstances().size(); ++j) {
                    distanceVectorsP.add(new float[model.getValidInstances().size()]);
                    float[] c1 = new float[]{((SimpleTreeInstance)model.getValidInstances().get(j)).getX(), ((SimpleTreeInstance)model.getValidInstances().get(j)).getY()};
                    for (int k = 0; k < model.getValidInstances().size(); ++k) {
                        float dist;
                        float[] c2 = new float[]{((SimpleTreeInstance)model.getValidInstances().get(k)).getX(), ((SimpleTreeInstance)model.getValidInstances().get(k)).getY()};
                        distanceVectorsP.get((int)j)[k] = dist = (float)Math.sqrt(Math.pow(c1[0] - c2[0], 2.0) + Math.pow(c1[1] - c2[1], 2.0));
                    }
                }
                float correlation = this.getCorrelationCoefficient(distanceVectorsO, distanceVectorsP);
                result = result + model.toString() + " correlation coefficient: " + correlation + "\r\n";
            }
        }
        if (projectionDmats != null && !projectionDmats.isEmpty()) {
            for (i = 0; i < projectionDmats.size(); ++i) {
                distanceVectorsP = new ArrayList();
                for (int j = 0; j < projectionDmats.get(i).getElementCount(); ++j) {
                    distanceVectorsP.add(new float[projectionDmats.get(i).getElementCount()]);
                    for (int k = 0; k < projectionDmats.get(i).getElementCount(); ++k) {
                        distanceVectorsP.get((int)j)[k] = projectionDmats.get(i).getDistance(j, k);
                    }
                }
                float correlation = this.getCorrelationCoefficient(distanceVectorsO, distanceVectorsP);
                result = projectionDmats.get(i) instanceof DetailedDistanceMatrix ? result + projectionDmats.get(i).getName() + " correlation coefficient: " + correlation + "\r\n" : result + "Distance Matrix " + i + " correlation coefficient: " + correlation + "\r\n";
            }
        }
        return result;
    }

    public String execute(DistanceMatrix dmat, ArrayList<SimpleTreeModel> models, ArrayList<ArrayList<Edge>> edges, ArrayList<ArrayList<Integer>> ids, boolean useEdgeWeights) throws IOException {
        int i;
        String result = "";
        ArrayList<float[]> distanceVectorsO = new ArrayList<float[]>();
        ArrayList<Object> distanceVectorsP = new ArrayList<float[]>();
        for (i = 0; i < dmat.getElementCount(); ++i) {
            distanceVectorsO.add(new float[dmat.getElementCount()]);
            for (int k = 0; k < dmat.getElementCount(); ++k) {
                ((float[])distanceVectorsO.get((int)i))[k] = dmat.getDistance(i, k);
            }
        }
        if (models != null && !models.isEmpty()) {
            for (i = 0; i < models.size(); ++i) {
                SimpleTreeModel model = models.get(i);
                distanceVectorsP = new ArrayList();
                for (int j = 0; j < model.getValidInstances().size(); ++j) {
                    distanceVectorsP.add(new float[model.getValidInstances().size()]);
                    float[] c1 = new float[]{((SimpleTreeInstance)model.getValidInstances().get(j)).getX(), ((SimpleTreeInstance)model.getValidInstances().get(j)).getY()};
                    for (int k = 0; k < model.getValidInstances().size(); ++k) {
                        float dist;
                        float[] c2 = new float[]{((SimpleTreeInstance)model.getValidInstances().get(k)).getX(), ((SimpleTreeInstance)model.getValidInstances().get(k)).getY()};
                        ((float[])distanceVectorsP.get((int)j))[k] = dist = (float)Math.sqrt(Math.pow(c1[0] - c2[0], 2.0) + Math.pow(c1[1] - c2[1], 2.0));
                    }
                }
                float correlation = this.getCorrelationCoefficient(distanceVectorsO, distanceVectorsP);
                result = result + model.toString() + " correlation coefficient: " + correlation + "\r\n";
            }
        }
        if (edges != null && !edges.isEmpty()) {
            TreeDistanceCalculator t = new TreeDistanceCalculator();
            for (int i2 = 0; i2 < edges.size(); ++i2) {
                ArrayList<Edge> edgeSet = edges.get(i2);
                ArrayList<Integer> idsSet = ids.get(i2);
                distanceVectorsP = new ArrayList();
                for (int j = 0; j < idsSet.size(); ++j) {
                    distanceVectorsP.add(new float[idsSet.size()]);
                    for (int k = 0; k < idsSet.size(); ++k) {
                        ((float[])distanceVectorsP.get((int)j))[k] = t.getDistance(edgeSet, idsSet.get(j), idsSet.get(k), useEdgeWeights);
                    }
                }
                for (int ii = 0; ii < distanceVectorsP.size(); ++ii) {
                    System.out.println();
                    for (int jj = 0; jj < ((float[])distanceVectorsP.get(ii)).length; ++jj) {
                        System.out.print(((float[])distanceVectorsP.get(ii))[jj] + " ");
                    }
                }
                float correlation = this.getCorrelationCoefficient(distanceVectorsO, distanceVectorsP);
                result = result + "Distance Matrix " + i2 + " correlation coefficient: " + correlation + "\r\n";
            }
        }
        return result;
    }

    private float getMean(float[] vector) {
        if (vector.length < 1) {
            return Float.NaN;
        }
        float sum = 0.0f;
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
        }
        return sum / (float)vector.length;
    }

    private float getStdDev(float[] vector) {
        float mean = this.getMean(vector);
        float sum = 0.0f;
        for (int i = 0; i < vector.length; ++i) {
            sum = (float)((double)sum + Math.pow(vector[i] - mean, 2.0));
        }
        return (float)Math.sqrt(sum / (float)(vector.length - 1));
    }

    private float[] product(float[] vec1, float[] vec2) {
        float[] ret = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            ret[i] = vec1[i] * vec2[i];
        }
        return ret;
    }

    private float getCorrelationCoefficient(ArrayList<float[]> distanceVectorsO, ArrayList<float[]> distanceVectorsP) {
        if (distanceVectorsO.size() != distanceVectorsP.size()) {
            return Float.NaN;
        }
        float correlation = 0.0f;
        for (int i = 0; i < distanceVectorsO.size(); ++i) {
            float meanProduct = this.getMean(this.product(distanceVectorsO.get(i), distanceVectorsP.get(i)));
            float meanO = this.getMean(distanceVectorsO.get(i));
            float meanP = this.getMean(distanceVectorsP.get(i));
            float stDevO = this.getStdDev(distanceVectorsO.get(i));
            float stDevP = this.getStdDev(distanceVectorsP.get(i));
            correlation += (meanProduct - meanO * meanP) / (stDevO * stDevP);
        }
        return correlation / (float)distanceVectorsO.size();
    }
}

