/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.stress.SimpleTreeStressCurveComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.AbstractFilter;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.DMATFilter;
import simpletree.view.forms.SimpleTreeSaveClassDialog;

public class SimpleTreeChecksDialog
extends JDialog {
    private static SimpleTreeChecksDialog instance;
    private SimpleTreeStressCurveComp comp;
    private int choice;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JComboBox dissimilarityComboBox;
    protected JPanel dissimilarityPanel;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JTextField labelTextField;
    protected JButton okButton;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private JPanel sourcePanel;
    private JPanel sourcePanel1;
    private JPanel treePanel;
    private JCheckBox useEuclideanAsWeightsCheckBox;
    private JCheckBox useVisEuclideanDistanceCheckBox;
    private JCheckBox useWeightCheckBox;

    public SimpleTreeChecksDialog(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setModal(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.sourcePanel = new JPanel();
        this.labelTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.sourcePanel1 = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.treePanel = new JPanel();
        this.useWeightCheckBox = new JCheckBox();
        this.useVisEuclideanDistanceCheckBox = new JCheckBox();
        this.useEuclideanAsWeightsCheckBox = new JCheckBox();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.sourcePanel.setLayout(new GridBagLayout());
        this.labelTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.labelTextField, gridBagConstraints);
        this.jLabel1.setText("Graphic Label : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.sourcePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.sourcePanel1.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel1.setLayout(new GridBagLayout());
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel1.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.sourcePanel.add((Component)this.sourcePanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.sourcePanel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createTitledBorder("Distance Parameters"));
        this.treePanel.setLayout(new GridBagLayout());
        this.useWeightCheckBox.setText("Use Edges Weights");
        this.useWeightCheckBox.setHorizontalAlignment(4);
        this.useWeightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.useWeightCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.treePanel.add((Component)this.useWeightCheckBox, gridBagConstraints);
        this.useVisEuclideanDistanceCheckBox.setText("Use Euclidean Distance (Visualization Plane)");
        this.useVisEuclideanDistanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeChecksDialog.this.useVisEuclideanDistanceCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.treePanel.add((Component)this.useVisEuclideanDistanceCheckBox, gridBagConstraints);
        this.useEuclideanAsWeightsCheckBox.setText("Use Plane Euclidean Distances as Weights");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.treePanel.add((Component)this.useEuclideanAsWeightsCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.treePanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.dissimilarityPanel, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String sourceFilename = "";
        if (this.choice == 0) {
            sourceFilename = this.pointsTextField.getText();
        } else if (this.choice == 1) {
            sourceFilename = this.distanceMatrixTextField.getText();
        }
        this.comp.setDataFileName(sourceFilename);
        this.comp.setDataFileType(this.choice);
        if (sourceFilename.isEmpty()) {
            JOptionPane.showMessageDialog(null, "The original data source must be informed!");
            return;
        }
        if (this.comp != null) {
            try {
                this.comp.setGraphicLabel(this.labelTextField.getText().trim());
                this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
                this.comp.setUseVisEuclidianDistance(this.useVisEuclideanDistanceCheckBox.isSelected());
                this.comp.setUseEuclideanAsWeights(this.useEuclideanAsWeightsCheckBox.isSelected());
                this.comp.setUseWeight(this.useWeightCheckBox.isSelected());
                this.comp.execute();
                this.setVisible(false);
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleTreeChecksDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void useWeightCheckBoxActionPerformed(ActionEvent evt) {
        if (this.useWeightCheckBox.isSelected()) {
            this.useEuclideanAsWeightsCheckBox.setEnabled(true);
        } else {
            this.useEuclideanAsWeightsCheckBox.setSelected(false);
            this.useEuclideanAsWeightsCheckBox.setEnabled(false);
        }
    }

    private void useVisEuclideanDistanceCheckBoxActionPerformed(ActionEvent evt) {
        if (this.useVisEuclideanDistanceCheckBox.isSelected()) {
            this.useWeightCheckBox.setSelected(false);
            this.useWeightCheckBox.setEnabled(false);
            this.useEuclideanAsWeightsCheckBox.setSelected(false);
            this.useEuclideanAsWeightsCheckBox.setEnabled(false);
        } else {
            this.useWeightCheckBox.setEnabled(true);
        }
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.dissimilarityComboBox.setEnabled(true);
        this.choice = 0;
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.dissimilarityComboBox.setEnabled(false);
        this.choice = 1;
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DATAFilter(), this.pointsTextField);
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DMATFilter(), this.distanceMatrixTextField);
    }

    private void pushButton(AbstractFilter filter, JTextField field) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, filter, this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                field.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeSaveClassDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SimpleTreeChecksDialog getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new SimpleTreeChecksDialog(parent);
        }
        return instance;
    }

    public void display(SimpleTreeStressCurveComp comp) {
        this.comp = comp;
        this.useEuclideanAsWeightsCheckBox.setSelected(false);
        this.useWeightCheckBox.setSelected(false);
        this.useEuclideanAsWeightsCheckBox.setSelected(false);
        this.useEuclideanAsWeightsCheckBox.setEnabled(false);
        switch (comp.getDataFileType()) {
            case 0: {
                this.dissimilarityPanel.setVisible(true);
                for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
                    this.dissimilarityComboBox.addItem(disstype);
                }
                break;
            }
            case 1: {
                this.dissimilarityPanel.setVisible(false);
            }
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

