/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import simpletree.stress.SimpleTreeStressCurveComp;
import simpletree.stress.StressCurveParamView;

public class SimpleTreeStressCurveParamView
extends StressCurveParamView {
    private JCheckBox useVisEuclideanDistanceCheckBox;
    private JCheckBox useWeightCheckBox;
    private JCheckBox useEuclideanAsWeightsCheckBox;
    private JPanel checkjPanel = new JPanel();
    protected SimpleTreeStressCurveComp comp;

    public SimpleTreeStressCurveParamView(SimpleTreeStressCurveComp comp) {
        super(comp);
        this.comp = comp;
        this.initComponents();
        this.useWeightCheckBox.setSelected(comp.getUseWeight());
        this.useVisEuclideanDistanceCheckBox.setSelected(comp.getUseVisEuclidianDistance());
        this.useEuclideanAsWeightsCheckBox.setSelected(comp.getUseEuclideanAsWeights());
        this.useWeightCheckBoxActionPerformed(null);
        this.useVisEuclideanDistanceCheckBoxActionPerformed(null);
    }

    @Override
    public void finished() throws IOException {
        super.finished();
        this.comp.setUseWeight(this.useWeightCheckBox.isSelected());
        this.comp.setUseVisEuclidianDistance(this.useVisEuclideanDistanceCheckBox.isSelected());
        this.comp.setUseEuclideanAsWeights(this.useEuclideanAsWeightsCheckBox.isSelected());
    }

    private void useVisEuclideanDistanceCheckBoxActionPerformed(ActionEvent evt) {
        if (this.useVisEuclideanDistanceCheckBox.isSelected()) {
            this.useWeightCheckBox.setSelected(false);
            this.useWeightCheckBox.setEnabled(false);
            this.useEuclideanAsWeightsCheckBox.setSelected(false);
            this.useEuclideanAsWeightsCheckBox.setEnabled(false);
        } else {
            this.useWeightCheckBox.setEnabled(true);
        }
    }

    private void useWeightCheckBoxActionPerformed(ActionEvent evt) {
        if (this.useWeightCheckBox.isSelected()) {
            this.useEuclideanAsWeightsCheckBox.setEnabled(true);
        } else {
            this.useEuclideanAsWeightsCheckBox.setSelected(false);
            this.useEuclideanAsWeightsCheckBox.setEnabled(false);
        }
    }

    private void initComponents() {
        this.checkjPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.checkjPanel.setLayout(new GridBagLayout());
        this.generalPanel.add(this.checkjPanel);
        this.useVisEuclideanDistanceCheckBox = new JCheckBox();
        this.useVisEuclideanDistanceCheckBox.setText("Use Euclidean Distance (Visualization Plane)");
        this.useVisEuclideanDistanceCheckBox.setSelected(false);
        this.useVisEuclideanDistanceCheckBox.setHorizontalAlignment(4);
        this.useVisEuclideanDistanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeStressCurveParamView.this.useVisEuclideanDistanceCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        this.checkjPanel.add((Component)this.useVisEuclideanDistanceCheckBox, gridBagConstraints2);
        this.useWeightCheckBox = new JCheckBox();
        this.useWeightCheckBox.setText("Use Edges Weights");
        this.useWeightCheckBox.setSelected(true);
        this.useWeightCheckBox.setHorizontalAlignment(4);
        this.useWeightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeStressCurveParamView.this.useWeightCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        this.checkjPanel.add((Component)this.useWeightCheckBox, gridBagConstraints2);
        this.useEuclideanAsWeightsCheckBox = new JCheckBox();
        this.useEuclideanAsWeightsCheckBox.setText("Use Plane Euclidean Distances as Weights");
        this.useEuclideanAsWeightsCheckBox.setSelected(false);
        this.useEuclideanAsWeightsCheckBox.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        this.checkjPanel.add((Component)this.useEuclideanAsWeightsCheckBox, gridBagConstraints2);
    }
}

