/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.connection.nj;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.technique.connection.GraphConnection;
import simpletree.technique.connection.nj.NeighborJoining;

public class NJConnection
extends GraphConnection {
    private NeighborJoining neighbor;

    @Override
    public Connectivity execute(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    @Override
    public Connectivity execute(DistanceMatrix dmat) throws IOException {
        int numberPoints = dmat.getElementCount();
        this.neighbor = new NeighborJoining(numberPoints);
        this.neighbor.doNeighbor(dmat);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < this.neighbor.get_size(); ++i) {
            float dis = this.neighbor.get_dis_are(i);
            int sour = this.neighbor.get_source_are(i);
            int targ = this.neighbor.get_target_are(i);
            edges.add(new Edge(sour, targ, dis));
        }
        Connectivity conn = new Connectivity("Neighbor-Joinning", edges);
        return conn;
    }
}

