/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.connection.nj;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.Connectivity;
import simpletree.technique.connection.nj.NJConnection;
import simpletree.technique.connection.nj.NJConnectionParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Graph.Connection.Technique", name="Neighbor-Joinning connection", description="Project points from a multidimensional space to the plane preserving the neighborhood relations.")
public class NJConnectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient NJConnectionParamView paramview;
    private transient Connectivity conn;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        NJConnection nj = new NJConnection();
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.conn = nj.execute(this.matrix, diss);
        } else if (this.dmat != null) {
            this.conn = nj.execute(this.dmat);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public Connectivity output() {
        return this.conn;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new NJConnectionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.conn = null;
        this.matrix = null;
        this.dmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }
}

