/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.connection.nj;

import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.technique.connection.nj.Content;
import simpletree.technique.connection.nj.NJEdges;

public class NeighborJoining
extends Content {
    private int numberPoints;
    private int m_pCluster;
    private int m_Fil;
    private Content[] m_pTempMatH;
    private float[] Divergence_V;
    private float[][] matriz;
    private int m_Posx;
    private int m_Posy;
    private float m_Dx;
    private float m_Dy;
    private int m_PosJun;
    private ArrayList<NJEdges> Varesta = new ArrayList();

    public NeighborJoining(int numberPoints) {
        this.numberPoints = numberPoints;
        this.m_PosJun = numberPoints;
        this.m_pCluster = numberPoints;
        this.m_Fil = numberPoints + (numberPoints - 2);
    }

    public void doNeighbor(DistanceMatrix dmat) {
        this.m_pTempMatH = new Content[this.m_Fil];
        for (int k = 0; k < this.m_Fil; ++k) {
            this.m_pTempMatH[k] = new Content();
        }
        this.createDistanceMatrix(dmat);
        do {
            this.Divergence_V = this.calDivergence(this.m_PosJun);
            this.matrixDistance(this.Divergence_V, this.m_PosJun, this.m_pCluster);
            this.branchLengths(this.Divergence_V, this.m_pCluster);
            this.nodeJoin(this.m_PosJun);
            this.distNewNode(this.m_PosJun);
            --this.m_pCluster;
            ++this.m_PosJun;
        } while (this.m_pCluster > 2);
        this.getarestas();
    }

    public float[] calDivergence(int m_PosJun) {
        int m_pSizeV = m_PosJun;
        float[] m_vDivergence = new float[m_pSizeV];
        int p = this.m_Fil - 1;
        for (int i = 0; i < m_pSizeV; ++i) {
            if (this.m_pTempMatH[i].m_pFlag >= 0) {
                float m_pSum = 0.0f;
                for (int j = 0; j < i; ++j) {
                    if (this.m_pTempMatH[j].m_pFlag < 0) continue;
                    m_pSum += this.matriz[j][p - i];
                }
                for (int k = i + 1; k < m_pSizeV; ++k) {
                    if (this.m_pTempMatH[k].m_pFlag < 0) continue;
                    m_pSum += this.matriz[i][p - k];
                }
                m_vDivergence[i] = m_pSum;
                continue;
            }
            m_vDivergence[i] = 0.0f;
        }
        return m_vDivergence;
    }

    public void matrixDistance(float[] r, int m_PosJun, int m_PCluster) {
        float m_pMinDistance = 0.0f;
        int m_pSizeV = m_PosJun;
        int p = this.m_Fil - 1;
        for (int i = 0; i < m_pSizeV - 1; ++i) {
            if (this.m_pTempMatH[i].m_pFlag < 0) continue;
            for (int j = i + 1; j < m_pSizeV; ++j) {
                float m_pValue;
                if (this.m_pTempMatH[j].m_pFlag < 0 || !((m_pValue = this.matriz[i][p - j] - (r[i] + r[j]) / (float)(m_PCluster - 2)) < m_pMinDistance) && m_pMinDistance != 0.0f) continue;
                m_pMinDistance = m_pValue;
                this.m_Posx = i;
                this.m_Posy = j;
            }
        }
    }

    public void branchLengths(float[] r, int m_PCluster) {
        int A = this.m_Posx;
        int B = this.m_Posy;
        int p = this.m_Fil - 1;
        this.m_Dx = 0.5f * this.matriz[A][p - B] + (r[A] - r[B]) / (float)(2 * (m_PCluster - 2));
        this.m_Dy = this.matriz[A][p - B] - this.m_Dx;
    }

    void nodeJoin(int m_PosJun) {
        this.m_pTempMatH[m_PosJun].m_pFolha1 = this.m_Posx;
        this.m_pTempMatH[m_PosJun].m_pFolha2 = this.m_Posy;
        this.m_pTempMatH[m_PosJun].m_pFlag = 1;
        this.m_pTempMatH[m_PosJun].m_pFlagP = 0;
        this.m_pTempMatH[m_PosJun].m_pDis_F = 0.0f;
        this.m_pTempMatH[m_PosJun].m_pFlagT = 0;
        this.m_pTempMatH[m_PosJun].m_pInter = -3;
        if (this.m_pTempMatH[this.m_Posx].m_pFlag == 0) {
            this.m_pTempMatH[this.m_Posx].m_pFolha1 = m_PosJun;
            this.m_pTempMatH[this.m_Posx].m_pDis_F = this.m_Dx;
            this.m_pTempMatH[this.m_Posx].m_pFlag = -1;
        } else {
            this.m_pTempMatH[this.m_Posx].m_pInter = m_PosJun;
            this.m_pTempMatH[this.m_Posx].m_pDis_F = this.m_Dx;
            this.m_pTempMatH[this.m_Posx].m_pFlag = -2;
        }
        if (this.m_pTempMatH[this.m_Posy].m_pFlag == 0) {
            this.m_pTempMatH[this.m_Posy].m_pFolha1 = m_PosJun;
            this.m_pTempMatH[this.m_Posy].m_pDis_F = this.m_Dy;
            this.m_pTempMatH[this.m_Posy].m_pFlag = -1;
        } else {
            this.m_pTempMatH[this.m_Posy].m_pInter = m_PosJun;
            this.m_pTempMatH[this.m_Posy].m_pDis_F = this.m_Dy;
            this.m_pTempMatH[this.m_Posy].m_pFlag = -2;
        }
    }

    public void distNewNode(int m_PosJun) {
        float m_pMinDistance = 0.0f;
        int p = this.m_Fil - 1;
        int m_pInt = 0;
        int m_pPosX = this.m_Posx;
        int m_pPosY = this.m_Posy;
        for (int i = 0; i < m_PosJun; ++i) {
            if (this.m_pTempMatH[i].m_pFlag < 0) continue;
            float m_pTempX = m_pPosX > i ? this.matriz[i][p - m_pPosX] : this.matriz[m_pPosX][p - i];
            float m_pTempY = m_pPosY > i ? this.matriz[i][p - m_pPosY] : this.matriz[m_pPosY][p - i];
            this.matriz[i][p - m_PosJun] = m_pMinDistance = 0.5f * (m_pTempX + m_pTempY - this.matriz[m_pPosX][p - m_pPosY]);
        }
        if (this.m_pCluster - 1 == 2) {
            for (int a = 0; a < p; ++a) {
                if (this.m_pTempMatH[a].m_pInter != -3) continue;
                m_pInt = a + m_pInt;
            }
            this.m_pTempMatH[m_PosJun].m_pInter = m_pInt;
            this.m_pTempMatH[m_pInt].m_pInter = m_PosJun;
            this.m_pTempMatH[m_PosJun].m_pDis_F = m_pMinDistance;
            this.m_pTempMatH[m_pInt].m_pDis_F = m_pMinDistance;
            this.m_pTempMatH[m_PosJun].m_pFlag = -2;
            this.m_pTempMatH[m_pInt].m_pFlag = -2;
        }
    }

    public void createDistanceMatrix(DistanceMatrix dmat) {
        int k;
        this.matriz = new float[this.m_Fil][];
        int i = 0;
        int f = this.m_Fil;
        while (i < this.m_Fil) {
            this.matriz[i] = new float[f];
            for (k = 0; k < f; ++k) {
                this.matriz[i][k] = 0.0f;
            }
            ++i;
            --f;
        }
        int f2 = this.m_Fil - 1;
        int l = 0;
        while (l < this.numberPoints - 1) {
            k = this.numberPoints - 2;
            int j = 0;
            while (k < f2) {
                this.matriz[l][k] = dmat.getDistance(l, this.numberPoints - 1 - j);
                ++k;
                ++j;
            }
            ++l;
            --f2;
        }
    }

    public void getarestas() {
        for (int b = 0; b < this.m_Fil; ++b) {
            if (this.m_pTempMatH[b].m_pFlagP == 1) continue;
            int m_temp = this.m_pTempMatH[b].m_pFolha1;
            this.newickSon(m_temp);
        }
    }

    public void newickSon(int i) {
        NJEdges aux;
        int m_pSon1 = this.m_pTempMatH[i].m_pFolha1;
        int m_pSon2 = this.m_pTempMatH[i].m_pFolha2;
        int m_pSon3 = this.m_pTempMatH[i].m_pInter;
        this.m_pTempMatH[i].m_pFlagP = 1;
        if (this.m_pTempMatH[m_pSon1].m_pFlag == -1 && this.m_pTempMatH[m_pSon1].m_pFlagP != 1) {
            aux = new NJEdges();
            aux.addiele(this.m_pTempMatH[m_pSon1].m_pDis_F, i, m_pSon1);
            this.Varesta.add(aux);
            this.m_pTempMatH[m_pSon1].m_pFlagP = 1;
        }
        if (this.m_pTempMatH[m_pSon1].m_pFlag == -2 && this.m_pTempMatH[m_pSon1].m_pFlagP != 1) {
            this.newickSon(m_pSon1);
            aux = new NJEdges();
            aux.addiele(this.m_pTempMatH[m_pSon1].m_pDis_F, i, m_pSon1);
            this.Varesta.add(aux);
            this.m_pTempMatH[m_pSon1].m_pFlagP = 1;
        }
        if (this.m_pTempMatH[m_pSon2].m_pFlag == -1 && this.m_pTempMatH[m_pSon2].m_pFlagP != 1) {
            aux = new NJEdges();
            aux.addiele(this.m_pTempMatH[m_pSon2].m_pDis_F, i, m_pSon2);
            this.Varesta.add(aux);
            this.m_pTempMatH[m_pSon2].m_pFlagP = 1;
        }
        if (this.m_pTempMatH[m_pSon2].m_pFlag == -2 && this.m_pTempMatH[m_pSon2].m_pFlagP != 1) {
            this.newickSon(m_pSon2);
            aux = new NJEdges();
            aux.addiele(this.m_pTempMatH[m_pSon2].m_pDis_F, i, m_pSon2);
            this.Varesta.add(aux);
            this.m_pTempMatH[m_pSon2].m_pFlagP = 1;
        }
        if (m_pSon3 > 0 && this.m_pTempMatH[m_pSon3].m_pFlagP != 1) {
            this.newickSon(m_pSon3);
            aux = new NJEdges();
            aux.addiele(this.m_pTempMatH[i].m_pDis_F, i, m_pSon3);
            this.Varesta.add(aux);
            this.m_pTempMatH[m_pSon3].m_pFlagP = 1;
        }
        this.m_pTempMatH[i].m_pFlagP = 1;
    }

    public float get_dis_are(int i) {
        NJEdges aresta = this.Varesta.get(i);
        float a = aresta.dist;
        return a;
    }

    public int get_source_are(int i) {
        NJEdges aresta = this.Varesta.get(i);
        int a = aresta.source;
        return a;
    }

    public int get_target_are(int i) {
        NJEdges aresta = this.Varesta.get(i);
        int a = aresta.target;
        return a;
    }

    public int get_size() {
        return this.Varesta.size();
    }
}

