/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.lsp;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import lspsolver.Solver;
import simpletree.datamining.neighbors.ANN;
import simpletree.datamining.neighbors.Pair;
import simpletree.datamining.sampling.Sampling;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.Projection;
import simpletree.projection.technique.idmap.IDMAPProjection;
import simpletree.technique.lsp.CreateNNG;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class LSPProjection2D
implements Projection {
    private AbstractMatrix sampleproj;
    private AbstractMatrix sampledata;
    private Sampling.SampleType sampletype = Sampling.SampleType.RANDOM;
    private int samplesize = -1;
    private int nrneighbors = 10;
    private float fracdelta = 8.0f;
    private int nriterations = 50;

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        long start = System.currentTimeMillis();
        if (this.sampledata == null) {
            if (this.samplesize == -1) {
                this.samplesize = matrix.getRowCount() / 10;
            }
            this.sampledata = this.getSampleData(matrix, diss, this.samplesize);
            this.sampleproj = this.projectSampleData(this.sampledata, diss);
        } else if (this.sampleproj == null) {
            this.sampleproj = this.projectSampleData(this.sampledata, diss);
            this.samplesize = this.sampleproj.getRowCount();
        } else {
            this.samplesize = this.sampleproj.getRowCount();
        }
        ANN appknn = new ANN(this.nrneighbors);
        Pair[][] neighbors = appknn.execute(matrix, diss);
        CreateNNG nng = new CreateNNG();
        nng.execute(neighbors, matrix, diss);
        AbstractMatrix projection = this.projectUsingColt(matrix, neighbors);
        Runtime.getRuntime().gc();
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Least Square Projection (LSP) time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Sampling.SampleType getSampleType() {
        return this.sampletype;
    }

    public void setSampleType(Sampling.SampleType sampletype) {
        this.sampletype = sampletype;
    }

    public int getSampleSize() {
        return this.samplesize;
    }

    public void setSampleSize(int samplesize) {
        this.samplesize = samplesize;
    }

    public void setSampleProjection(AbstractMatrix sampleproj) {
        this.sampleproj = sampleproj;
    }

    public void setSampleMatrix(AbstractMatrix samplematrix) {
        this.sampledata = samplematrix;
    }

    protected AbstractMatrix getSampleData(AbstractMatrix matrix, AbstractDissimilarity diss, int samplesize) throws IOException {
        Sampling sampling = new Sampling(this.sampletype, samplesize);
        AbstractMatrix sampledata_aux = sampling.execute(matrix, diss);
        return sampledata_aux;
    }

    protected AbstractMatrix projectSampleData(AbstractMatrix sample, AbstractDissimilarity diss) throws IOException {
        IDMAPProjection idmap = new IDMAPProjection();
        idmap.setFractionDelta(this.fracdelta);
        idmap.setNumberIterations(this.nriterations);
        this.sampleproj = idmap.project(sample, diss);
        return this.sampleproj;
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    private AbstractMatrix projectUsingColt(AbstractMatrix matrix, Pair[][] neighbors) {
        long start = System.currentTimeMillis();
        ArrayList<Integer> ids = matrix.getIds();
        float[] cdata = matrix.getClassData();
        ArrayList<String> labels = matrix.getLabels();
        int nRows = neighbors.length + this.samplesize;
        int nColumns = neighbors.length;
        SparseDoubleMatrix2D A = new SparseDoubleMatrix2D(nRows, nColumns);
        for (int i = 0; i < neighbors.length; ++i) {
            float dist;
            int j;
            A.setQuick(i, i, 1.0);
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int j2 = 0; j2 < neighbors[i].length; ++j2) {
                if (max < neighbors[i][j2].value) {
                    max = neighbors[i][j2].value;
                }
                if (!(min > neighbors[i][j2].value)) continue;
                min = neighbors[i][j2].value;
            }
            float sum = 0.0f;
            for (j = 0; j < neighbors[i].length; ++j) {
                if (!(max > min)) continue;
                dist = (neighbors[i][j].value - min) / (max - min) * 0.9f + 0.1f;
                sum += 1.0f / dist;
            }
            for (j = 0; j < neighbors[i].length; ++j) {
                if (max > min) {
                    dist = (neighbors[i][j].value - min) / (max - min) * 0.9f + 0.1f;
                    A.setQuick(i, neighbors[i][j].index, (double)(-(1.0f / dist / sum)));
                    continue;
                }
                A.setQuick(i, neighbors[i][j].index, (double)(-(1.0f / (float)neighbors[i].length)));
            }
        }
        int[] sampleids = this.getSampleIds(matrix, this.sampledata);
        for (int i = 0; i < this.samplesize; ++i) {
            A.setQuick(neighbors.length + i, sampleids[i], 1.0);
        }
        SparseDoubleMatrix2D B = new SparseDoubleMatrix2D(nRows, 2);
        for (int i = 0; i < this.sampleproj.getRowCount(); ++i) {
            B.setQuick(neighbors.length + i, 0, (double)this.sampleproj.getRow(i).getValue(0));
            B.setQuick(neighbors.length + i, 1, (double)this.sampleproj.getRow(i).getValue(1));
        }
        DoubleMatrix2D AtA = A.zMult((DoubleMatrix2D)A, null, 1.0, 1.0, true, false);
        DoubleMatrix2D AtB = A.zMult((DoubleMatrix2D)B, null, 1.0, 1.0, true, false);
        CholeskyDecomposition chol = new CholeskyDecomposition(AtA);
        DoubleMatrix2D X = chol.solve(AtB);
        DenseMatrix projection = new DenseMatrix();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        projection.setAttributes(attributes);
        for (int i = 0; i < X.rows(); ++i) {
            float[] vect = new float[]{(float)X.getQuick(i, 0), (float)X.getQuick(i, 1)};
            DenseVector vector = new DenseVector(vect, ids.get(i), cdata[i]);
            if (labels.isEmpty()) {
                ((AbstractMatrix)projection).addRow(vector);
                continue;
            }
            projection.addRow(vector, labels.get(i));
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using Colt time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    private AbstractMatrix projectUsingProgram(AbstractMatrix matrix, Pair[][] neighbors) throws IOException {
        int i;
        long start = System.currentTimeMillis();
        ArrayList<Integer> ids = matrix.getIds();
        float[] cdata = matrix.getClassData();
        ArrayList<String> labels = matrix.getLabels();
        int nRows = neighbors.length + this.samplesize;
        int nColumns = neighbors.length;
        Solver solver = new Solver(nRows, nColumns);
        for (int i2 = 0; i2 < neighbors.length; ++i2) {
            float dist;
            int j;
            solver.addToA(i2, i2, 1.0f);
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int j2 = 0; j2 < neighbors[i2].length; ++j2) {
                if (max < neighbors[i2][j2].value) {
                    max = neighbors[i2][j2].value;
                }
                if (!(min > neighbors[i2][j2].value)) continue;
                min = neighbors[i2][j2].value;
            }
            float sum = 0.0f;
            for (j = 0; j < neighbors[i2].length; ++j) {
                if (!(max > min)) continue;
                dist = (neighbors[i2][j].value - min) / (max - min) * 0.9f + 0.1f;
                sum += 1.0f / dist;
            }
            for (j = 0; j < neighbors[i2].length; ++j) {
                if (max > min) {
                    dist = (neighbors[i2][j].value - min) / (max - min) * 0.9f + 0.1f;
                    solver.addToA(i2, neighbors[i2][j].index, -(1.0f / dist / sum));
                    continue;
                }
                solver.addToA(i2, neighbors[i2][j].index, -(1.0f / (float)neighbors[i2].length));
            }
        }
        int[] sampleids = this.getSampleIds(matrix, this.sampledata);
        for (i = 0; i < this.samplesize; ++i) {
            solver.addToA(neighbors.length + i, sampleids[i], 1.0f);
        }
        for (i = 0; i < this.sampleproj.getRowCount(); ++i) {
            solver.addToB(neighbors.length + i, 0, this.sampleproj.getRow(i).getValue(0));
            solver.addToB(neighbors.length + i, 1, this.sampleproj.getRow(i).getValue(1));
        }
        float[] result = solver.solve();
        DenseMatrix projection = new DenseMatrix();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        projection.setAttributes(attributes);
        for (int i3 = 0; i3 < result.length; i3 += 2) {
            float[] vect = new float[]{result[i3], result[i3 + 1]};
            DenseVector vector = new DenseVector(vect, ids.get(i3 / 2), cdata[i3 / 2]);
            if (labels.isEmpty()) {
                ((AbstractMatrix)projection).addRow(vector);
                continue;
            }
            projection.addRow(vector, labels.get(i3 / 2));
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using LSPSolver time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    private int[] getSampleIds(AbstractMatrix matrix, AbstractMatrix sample) {
        int i;
        int[] sampleids = new int[sample.getRowCount()];
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        for (i = 0; i < matrix.getRowCount(); ++i) {
            mapping.put(matrix.getRow(i).getId(), i);
        }
        for (i = 0; i < sample.getRowCount(); ++i) {
            sampleids[i] = (Integer)mapping.get(sample.getRow(i).getId());
        }
        return sampleids;
    }

    public static void main(String[] args) throws IOException {
        String filename = "C:\\Documents and Settings\\Administrador\\Desktop\\ProjWidget\\segmentation-normcols.data-notnull.data";
        AbstractMatrix matrix = MatrixFactory.getInstance(filename);
        ProjectionUtil.log(true, false);
        LSPProjection2D lsp = new LSPProjection2D();
        lsp.setNumberNeighbors(8);
        lsp.setSampleType(Sampling.SampleType.RANDOM);
        AbstractMatrix projection = lsp.project(matrix, new Euclidean());
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.setTitle("LSP");
        frame.execute();
    }
}

