/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.lsp;

import java.io.IOException;
import simpletree.datamining.sampling.Sampling;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.isomap.ISOMAPProjection;
import simpletree.technique.lsp.LSPProjection2D;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class LSPProjection2DISOMAP
extends LSPProjection2D {
    @Override
    protected AbstractMatrix projectSampleData(AbstractMatrix sample, AbstractDissimilarity diss) throws IOException {
        ISOMAPProjection isomap = new ISOMAPProjection();
        isomap.setNumberNeighbors(8);
        return isomap.project(sample, diss);
    }

    public static void main(String[] args) throws IOException {
        String filename = "C:\\Documents and Settings\\Administrador\\Desktop\\ProjWidget\\segmentation-normcols.data-notnull.data";
        AbstractMatrix matrix = MatrixFactory.getInstance(filename);
        ProjectionUtil.log(true, false);
        LSPProjection2DISOMAP lsp = new LSPProjection2DISOMAP();
        lsp.setNumberNeighbors(8);
        lsp.setSampleType(Sampling.SampleType.RANDOM);
        AbstractMatrix projection = lsp.project(matrix, new Euclidean());
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.setTitle("LSP");
        frame.execute();
    }
}

