/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.lsp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.technique.lsp.LSPProjection2DComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class LSPProjection2DParamView
extends AbstractParametersView {
    private LSPProjection2DComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JPanel lspPanel;
    private JLabel numberCPLabel;
    private JTextField numberCPTextField;
    private JLabel numberNeighborsLabel;
    private JTextField numberNeighborsTextField;

    public LSPProjection2DParamView(LSPProjection2DComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.lspPanel = new JPanel();
        this.numberCPLabel = new JLabel();
        this.numberNeighborsLabel = new JLabel();
        this.numberCPTextField = new JTextField();
        this.numberNeighborsTextField = new JTextField();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("LSP Parameters"));
        this.setLayout(new GridBagLayout());
        this.lspPanel.setBorder(BorderFactory.createTitledBorder("LSP parameters"));
        this.lspPanel.setLayout(new GridBagLayout());
        this.numberCPLabel.setText("Number Control Points");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberCPLabel, gridBagConstraints);
        this.numberNeighborsLabel.setText("Number of Neighbors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberNeighborsLabel, gridBagConstraints);
        this.numberCPTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberCPTextField, gridBagConstraints);
        this.numberNeighborsTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberNeighborsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.lspPanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
    }

    public void reset() {
        int nrinstances = this.comp.getNumberInstances();
        this.comp.setSampleSize(Math.max(nrinstances / 10, this.comp.getSampleSize()));
        int nrneighbors = 0;
        nrneighbors = this.comp.getNumberInstances() < 1500 ? 10 : (this.comp.getNumberInstances() < 5000 ? 15 : 20);
        this.comp.setNumberNeighbors(Math.max(nrneighbors, this.comp.getNumberNeighbors()));
        this.numberCPTextField.setText(Integer.toString(this.comp.getSampleSize()));
        this.numberNeighborsTextField.setText(Integer.toString(this.comp.getNumberNeighbors()));
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
    }

    public void finished() throws IOException {
        int nnei;
        int ncp;
        if (this.numberCPTextField.getText().trim().length() > 0) {
            ncp = Integer.parseInt(this.numberCPTextField.getText());
            if (ncp <= 0) {
                throw new IOException("The number of control points should be positive.");
            }
        } else {
            throw new IOException("The number of control points should be provided.");
        }
        this.comp.setSampleSize(ncp);
        if (this.numberNeighborsTextField.getText().trim().length() > 0) {
            nnei = Integer.parseInt(this.numberNeighborsTextField.getText());
            if (nnei <= 0) {
                throw new IOException("The number of neighbors should be positive.");
            }
        } else {
            throw new IOException("The number of neighbors should be provided.");
        }
        this.comp.setNumberNeighbors(nnei);
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
    }
}

