/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.msnj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.technique.msnj.MultiScaleNJConnectionComp;
import simpletree.technique.packagenj.PackageNJ;
import vispipelinebasics.interfaces.AbstractParametersView;

public class MultiScaleNJConnectionParamView
extends AbstractParametersView {
    protected MultiScaleNJConnectionComp comp;
    private JComboBox algorithmComboBox;
    private JPanel algorithmPanel;
    private ButtonGroup buttonGroup1;
    private JComboBox dissimilarityComboBox;
    protected JPanel dissimilarityPanel;
    private JPanel jPanel1;
    private JLabel levelsExpandedLabel;
    private JTextField levelsExpendedText;
    private JCheckBox pnjCheckBox;

    public MultiScaleNJConnectionParamView(MultiScaleNJConnectionComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : PackageNJ.NJAlgorithmType.values()) {
            this.algorithmComboBox.addItem(enum_);
        }
        this.algorithmComboBox.setSelectedItem((Object)PackageNJ.NJAlgorithmType.RAPID);
        this.reset();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.algorithmPanel = new JPanel();
        this.algorithmComboBox = new JComboBox();
        this.pnjCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.levelsExpandedLabel = new JLabel();
        this.levelsExpendedText = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder("Neighbor Joining Connection Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.algorithmPanel.setBorder(BorderFactory.createTitledBorder("NJ Algorithm"));
        this.algorithmPanel.setLayout(new GridBagLayout());
        this.algorithmComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiScaleNJConnectionParamView.this.algorithmComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.algorithmPanel.add((Component)this.algorithmComboBox, gridBagConstraints);
        this.pnjCheckBox.setText("Leaf Promotion");
        this.pnjCheckBox.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.algorithmPanel.add((Component)this.pnjCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.algorithmPanel, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel1.setLayout(new GridBagLayout());
        this.levelsExpandedLabel.setText("Levels Expanded:");
        this.jPanel1.add((Component)this.levelsExpandedLabel, new GridBagConstraints());
        this.levelsExpendedText.setColumns(5);
        this.levelsExpendedText.setText("1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.levelsExpendedText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add(this.jPanel1, gridBagConstraints);
    }

    private void algorithmComboBoxActionPerformed(ActionEvent evt) {
    }

    public void reset() {
        this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        this.pnjCheckBox.setSelected(this.comp.isPnj());
        if (this.comp.getNjAlgorithmType() != null) {
            this.algorithmComboBox.setSelectedItem((Object)this.comp.getNjAlgorithmType());
        } else {
            this.algorithmComboBox.setSelectedItem((Object)PackageNJ.NJAlgorithmType.RAPID);
        }
        this.levelsExpendedText.setText(Integer.toString(this.comp.getLevelsExpanded()));
    }

    public void finished() throws IOException {
        this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        this.comp.setPnj(this.pnjCheckBox.isSelected());
        this.comp.setNjAlgorithmType((PackageNJ.NJAlgorithmType)((Object)this.algorithmComboBox.getSelectedItem()));
        this.comp.setLevelsExpanded(Integer.valueOf(this.levelsExpendedText.getText()));
    }
}

