/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.packagenj;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Scanner;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.technique.packagenj.PexMatrix;
import simpletree.util.Util;

public class DistanceMatrixReader {
    public static double[][] loadLower(String file) throws IOException, ParseException {
        try {
            Scanner s = new Scanner(new BufferedReader(new FileReader(file)));
            int n = s.nextInt();
            s.useDelimiter("\\s*;\\s*|;?\\s*\\n");
            double[][] M = new double[n][];
            M[0] = new double[1];
            for (int i = 1; i < n; ++i) {
                M[i] = new double[i + 1];
                for (int j = 0; j < i; ++j) {
                    M[i][j] = s.nextDouble();
                }
                M[i][i] = 0.0;
            }
            s.close();
            return M;
        }
        catch (NoSuchElementException e) {
            throw new ParseException("Format mismatch in " + file, 0);
        }
    }

    public static int[][] loadInt(String file) throws ParseException, IOException {
        try {
            Scanner s = new Scanner(new BufferedReader(new FileReader(file)));
            s.useDelimiter("\\s*;\\s*|;?\\s*\\n|\\s+|\\n");
            int n = s.nextInt();
            int m = s.nextInt();
            int[][] M = new int[n][m];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < m; ++j) {
                    M[i][j] = s.nextInt();
                }
            }
            s.close();
            return M;
        }
        catch (NoSuchElementException e) {
            throw new ParseException("Misformatted file: " + file, 0);
        }
    }

    public static PexMatrix loadPex(String dmatFile) throws IOException, ParseException {
        String st = "";
        try {
            int i;
            Scanner s = new Scanner(new BufferedReader(new FileReader(dmatFile)));
            PexMatrix D = new PexMatrix();
            D.n = s.nextInt();
            s.nextLine();
            D.labels = s.nextLine().split("\\s*;\\s*");
            D.ids = new int[D.labels.length];
            for (int i2 = 0; i2 < D.labels.length; ++i2) {
                D.ids[i2] = Util.isParsableToInt(D.labels[i2]) ? Integer.parseInt(D.labels[i2]) : Util.convertToInt(D.labels[i2]);
            }
            String[] cdata = s.nextLine().split(";");
            D.classes = new float[D.n];
            for (i = 0; i < D.n; ++i) {
                Float n = Float.valueOf(Float.parseFloat(cdata[i]));
                D.classes[i] = n.floatValue();
            }
            s.useDelimiter("\\s*;\\s*|;?\\s*\\n");
            D.M = new double[D.n][];
            D.M[0] = new double[1];
            for (i = 1; i < D.n; ++i) {
                D.M[i] = new double[i + 1];
                for (int j = 0; j < i; ++j) {
                    st = s.next();
                    D.M[i][j] = Double.parseDouble(st);
                }
                D.M[i][i] = 0.0;
            }
            s.close();
            return D;
        }
        catch (NoSuchElementException e) {
            throw new ParseException("Format mismatch in " + dmatFile, 0);
        }
    }

    public static PexMatrix loadPex(String pointsFile, AbstractDissimilarity diss) throws IOException, ParseException {
        String st = "";
        try {
            int j;
            int i;
            Scanner s = new Scanner(new BufferedReader(new FileReader(pointsFile)));
            PexMatrix D = new PexMatrix();
            String header = "";
            while (st.isEmpty()) {
                st = s.nextLine();
            }
            header = st;
            st = "";
            if (header.length() < 2) {
                return null;
            }
            char type = header.charAt(0);
            char classification = header.charAt(1);
            header = null;
            while (st.isEmpty()) {
                st = s.nextLine();
            }
            D.n = Integer.parseInt(st);
            st = "";
            while (st.isEmpty()) {
                st = s.nextLine();
            }
            int numAtts = Integer.parseInt(st);
            st = "";
            D.labels = new String[D.n];
            D.ids = new int[D.n];
            if (classification == 'Y') {
                D.classes = new float[D.n];
            }
            float[][] values = new float[D.n][];
            for (i = 0; i < D.n; ++i) {
                while (st.isEmpty()) {
                    st = s.nextLine();
                }
                String[] line = st.split(";");
                st = "";
                D.labels[i] = line[0];
                D.ids[i] = Util.isParsableToInt(line[0]) ? Integer.parseInt(line[0]) : Util.convertToInt(line[0]);
                if (classification == 'Y') {
                    D.classes[i] = Float.parseFloat(line[line.length - 1]);
                }
                values[i] = new float[numAtts];
                for (j = 1; j < line.length - 1; ++j) {
                    if (type == 'D') {
                        values[i][j - 1] = Float.parseFloat(line[j]);
                        continue;
                    }
                    if (type != 'S') continue;
                    values[i][Integer.parseInt((String)line[j].substring((int)0, (int)line[j].indexOf((String)":")))] = Float.parseFloat(line[j].substring(line[j].indexOf(":") + 1));
                }
            }
            s = null;
            D.M = new double[D.n][];
            D.M[0] = new double[1];
            for (i = 1; i < D.n; ++i) {
                D.M[i] = new double[i + 1];
                DenseVector v1 = new DenseVector(values[i]);
                for (j = 0; j < i; ++j) {
                    DenseVector v2 = new DenseVector(values[j]);
                    float distance = diss.calculate(v1, v2);
                    D.M[i][j] = distance;
                }
                D.M[i][i] = 0.0;
            }
            values = null;
            System.gc();
            return D;
        }
        catch (NoSuchElementException e) {
            throw new ParseException("Format mismatch in " + pointsFile, 0);
        }
    }

    public static PexMatrix loadPex(DistanceMatrix dmat) {
        int i;
        PexMatrix dm = new PexMatrix();
        dm.n = dmat.getElementCount();
        dm.ids = new int[dm.n];
        dm.labels = new String[dm.n];
        dm.classes = new float[dm.n];
        if (!dmat.getIds().isEmpty()) {
            for (i = 0; i < dm.n; ++i) {
                dm.ids[i] = dmat.getIds().get(i);
            }
        }
        if (dmat.getClassData().length > 0) {
            for (i = 0; i < dm.n; ++i) {
                dm.classes[i] = new Float(dmat.getClassData()[i]).floatValue();
            }
        }
        if (!dmat.getLabels().isEmpty()) {
            for (i = 0; i < dm.n; ++i) {
                dm.labels[i] = dmat.getLabels().get(i);
            }
        } else if (!dmat.getIds().isEmpty()) {
            for (i = 0; i < dm.n; ++i) {
                dm.labels[i] = dmat.getIds().get(i).toString();
            }
        } else {
            for (i = 0; i < dm.n; ++i) {
                dm.labels[i] = Integer.toString(i);
            }
        }
        dm.M = new double[dm.n][];
        dm.M[0] = new double[1];
        dm.M[0][0] = 0.0;
        try {
            for (i = 0; i < dmat.getDistmatrix().length; ++i) {
                dm.M[i + 1] = new double[dmat.getDistmatrix()[i].length + 1];
                for (int j = 0; j < dmat.getDistmatrix()[i].length; ++j) {
                    dm.M[i + 1][j] = dmat.getDistmatrix()[i][j];
                }
                dm.M[i + 1][dmat.getDistmatrix()[i].length] = 0.0;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return dm;
    }

    public static PexMatrix loadPex(AbstractMatrix matrix, AbstractDissimilarity diss) {
        int i;
        PexMatrix pexDistanceMatrix = new PexMatrix();
        pexDistanceMatrix.n = matrix.getRowCount();
        pexDistanceMatrix.ids = new int[pexDistanceMatrix.n];
        pexDistanceMatrix.labels = new String[pexDistanceMatrix.n];
        pexDistanceMatrix.classes = new float[pexDistanceMatrix.n];
        if (!matrix.getIds().isEmpty()) {
            ArrayList<Integer> matrixIds = matrix.getIds();
            for (int i2 = 0; i2 < pexDistanceMatrix.n; ++i2) {
                int id;
                pexDistanceMatrix.ids[i2] = id = ((Integer)matrixIds.get(i2)).intValue();
            }
        }
        if (matrix.getClassData().length > 0) {
            for (int i3 = 0; i3 < pexDistanceMatrix.n; ++i3) {
                pexDistanceMatrix.classes[i3] = new Float(matrix.getClassData()[i3]).floatValue();
            }
        }
        if (!matrix.getLabels().isEmpty()) {
            for (i = 0; i < pexDistanceMatrix.n; ++i) {
                pexDistanceMatrix.labels[i] = matrix.getLabels().get(i);
            }
        } else if (!matrix.getIds().isEmpty()) {
            for (i = 0; i < pexDistanceMatrix.n; ++i) {
                pexDistanceMatrix.labels[i] = matrix.getIds().get(i).toString();
            }
        } else {
            for (i = 0; i < pexDistanceMatrix.n; ++i) {
                pexDistanceMatrix.labels[i] = Integer.toString(i);
            }
        }
        pexDistanceMatrix.M = new double[pexDistanceMatrix.n][];
        try {
            for (i = 0; i < matrix.getRowCount(); ++i) {
                pexDistanceMatrix.M[i] = new double[i + 1];
                for (int j = 0; j <= i; ++j) {
                    double distance;
                    pexDistanceMatrix.M[i][j] = i == j ? 0.0 : (distance = (double)diss.calculate(matrix.getRow(i), matrix.getRow(j)));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return pexDistanceMatrix;
    }

    private static void printMatrix(PexMatrix m) {
        System.out.println("*****************************");
        for (int i = 0; i < m.M.length; ++i) {
            for (int j = 0; j < m.M[i].length; ++j) {
                System.out.print(m.M[i][j] + " ");
            }
            System.out.println(" ");
        }
        System.out.println("*****************************");
    }

    public static int[][] loadTspLib(String file) throws IOException {
        Scanner s = new Scanner(new BufferedReader(new FileReader(file)));
        int[][] A = null;
        int n = 0;
        while (s.hasNext()) {
            String str = s.next();
            if (str.equals("DIMENSION:")) {
                n = s.nextInt();
            }
            if (!str.equals("EDGE_WEIGHT_SECTION")) continue;
            int i = 0;
            int j = 0;
            A = new int[n][n];
            while (s.hasNextInt()) {
                A[i][j] = s.nextInt();
                i += (j = (j + 1) % n) == 0 ? 1 : 0;
            }
        }
        s.close();
        return A;
    }

    static void writeLower(double[][] M, String file) throws IOException {
        FileWriter f = new FileWriter(file);
        int n = M.length;
        f.write(String.format("%d\n", n));
        for (int i = 1; i < n; ++i) {
            int j;
            for (j = 0; j < i - 1; ++j) {
                f.write(String.format("%.15f;", M[i][j]));
            }
            f.write(String.format("%.15f\n", M[i][j]));
        }
        f.close();
    }

    static void writePEX(double[][] M, String file) throws IOException {
        int i;
        FileWriter f = new FileWriter(file);
        int n = M.length;
        f.write(String.format("%d\n", n));
        for (i = 0; i < n - 1; ++i) {
            f.write(String.format("%d;", i));
        }
        f.write(String.format("%d\n", i));
        for (i = 0; i < n - 1; ++i) {
            f.write("0;");
        }
        f.write("0\n");
        for (i = 1; i < n; ++i) {
            int j;
            for (j = 0; j < i - 1; ++j) {
                f.write(String.format("%.15f;", M[i][j]));
            }
            f.write(String.format("%.15f\n", M[i][j]));
        }
        f.close();
    }

    static double[][] genLowerEuclidian(int n, int d, int m) {
        int[] pts = new int[d * n];
        Random r = new Random(1L);
        for (int i = n * d - 1; i >= 0; --i) {
            pts[i] = r.nextInt(m);
        }
        double[][] M = new double[n][];
        M[0] = new double[1];
        for (int i = 1; i < n; ++i) {
            M[i] = new double[i + 1];
            for (int j = 0; j < i; ++j) {
                int sum = 0;
                for (int k = 0; k < d; ++k) {
                    int diff = pts[i * d + k] - pts[j * d + k];
                    sum += diff * diff;
                }
                M[i][j] = Math.sqrt(sum);
            }
            M[i][i] = 0.0;
        }
        return M;
    }

    public static void main(String[] args) throws IOException, ParseException {
        int[][] M = DistanceMatrixReader.loadInt("/home/gpt/Desktop/gpt/Desktop/x.mat");
        int n = M.length;
        int m = M[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                System.out.printf("%d ", M[i][j]);
            }
            System.out.println();
        }
    }
}

