/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.packagenj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.technique.packagenj.PackageNJ;
import simpletree.technique.packagenj.PackageNJConnectionComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.DATAFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class PackageNJConnectionParamView
extends AbstractParametersView {
    protected PackageNJConnectionComp comp;
    private JComboBox algorithmComboBox;
    private JPanel algorithmPanel;
    private JCheckBox createSingleRootCheckBox;
    private JComboBox dissimilarityComboBox;
    protected JPanel dissimilarityPanel;
    private JButton dmatButton;
    private JPanel dmatFilePanel;
    private JTextField dmatTextField;
    private JLabel jLabel1;
    private JCheckBox pnjCheckBox;

    public PackageNJConnectionParamView(PackageNJConnectionComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : PackageNJ.NJAlgorithmType.values()) {
            this.algorithmComboBox.addItem(enum_);
        }
        this.algorithmComboBox.setSelectedItem((Object)PackageNJ.NJAlgorithmType.RAPID);
        this.createSingleRootCheckBox.setVisible(false);
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.pnjCheckBox = new JCheckBox();
        this.algorithmPanel = new JPanel();
        this.algorithmComboBox = new JComboBox();
        this.dmatFilePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.dmatTextField = new JTextField();
        this.dmatButton = new JButton();
        this.createSingleRootCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Neighbor Joining Connection Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.pnjCheckBox.setText("Leaf Promotion");
        this.pnjCheckBox.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.pnjCheckBox, gridBagConstraints);
        this.algorithmPanel.setBorder(BorderFactory.createTitledBorder("NJ Algorithm"));
        this.algorithmComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackageNJConnectionParamView.this.algorithmComboBoxActionPerformed(evt);
            }
        });
        this.algorithmPanel.add(this.algorithmComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.algorithmPanel, gridBagConstraints);
        this.dmatFilePanel.setBorder(BorderFactory.createTitledBorder("Distance Matrix File"));
        this.dmatFilePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Distance Matrix File :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dmatFilePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.dmatTextField.setMinimumSize(new Dimension(100, 20));
        this.dmatTextField.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dmatFilePanel.add((Component)this.dmatTextField, gridBagConstraints);
        this.dmatButton.setText("Search...");
        this.dmatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackageNJConnectionParamView.this.dmatButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dmatFilePanel.add((Component)this.dmatButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.dmatFilePanel, gridBagConstraints);
        this.createSingleRootCheckBox.setText("Create Single Root");
        this.createSingleRootCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackageNJConnectionParamView.this.createSingleRootCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.add(this.createSingleRootCheckBox, gridBagConstraints);
    }

    private void dmatButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = OpenDialog.showOpenDialog(spm, new DATAFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.dmatTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PackageNJConnectionParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void algorithmComboBoxActionPerformed(ActionEvent evt) {
    }

    private void createSingleRootCheckBoxActionPerformed(ActionEvent evt) {
    }

    public void reset() {
        this.dmatFilePanel.setVisible(false);
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
            this.pnjCheckBox.setSelected(this.comp.isPnj());
        }
        if (this.comp.getNjAlgorithmType() != null) {
            this.algorithmComboBox.setSelectedItem((Object)this.comp.getNjAlgorithmType());
        } else {
            this.algorithmComboBox.setSelectedItem((Object)PackageNJ.NJAlgorithmType.RAPID);
        }
        this.dmatTextField.setText(this.comp.getDmatFile());
        this.createSingleRootCheckBox.setSelected(this.comp.isCreateSingleRoot());
    }

    public void finished() throws IOException {
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
        this.comp.setPnj(this.pnjCheckBox.isSelected());
        this.comp.setNjAlgorithmType((PackageNJ.NJAlgorithmType)((Object)this.algorithmComboBox.getSelectedItem()));
        if (!this.dmatTextField.getText().isEmpty()) {
            this.comp.setDmatFile(this.dmatTextField.getText());
        }
        this.comp.setCreateSingleRoot(this.createSingleRootCheckBox.isSelected());
    }
}

