/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import simpletree.matrix.AbstractVector;
import simpletree.model.AbstractInstance;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModel;

public class PolylineInstance
extends AbstractInstance {
    public static final int LATERAL_INSET = 10;
    public static final int BOTTOM_INSET = 10;
    public static final int TOP_INSET = 50;
    private float klass;
    private String label;
    private float[] originalvalues;
    private Point[] screenpositions;
    private Color color;

    public PolylineInstance(AbstractVector instance, String label) {
        super(instance.getId());
        this.klass = instance.getKlass();
        this.originalvalues = instance.toArray();
        this.label = label;
        this.screenpositions = null;
        this.color = null;
    }

    public PolylineInstance(AbstractVector instance) {
        this(instance, Integer.toString(instance.getId()));
    }

    public void draw(BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.screenpositions == null) {
            this.calculateScreenPositions();
        }
        if (this.color == null) {
            this.calculateColor();
        }
        ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)this.model;
        for (int i = 0; i < this.screenpositions.length - 1; ++i) {
            Point p1 = this.screenpositions[i];
            Point p2 = this.screenpositions[i + 1];
            if (this.selected) {
                g2.setColor(this.color);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                if (pmodel.isColoredInstances()) {
                    g2.setColor(this.color);
                } else {
                    g2.setColor(Color.LIGHT_GRAY);
                }
                g2.setComposite(AlphaComposite.getInstance(3, pmodel.getAlpha()));
            }
            g2.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    public boolean isInside(int x, int y) {
        if (this.screenpositions != null) {
            for (int i = 0; i < this.screenpositions.length - 1; ++i) {
                Point p1 = this.screenpositions[i];
                Point p2 = this.screenpositions[i + 1];
                double dist = Line2D.ptSegDist(p1.x, p1.y, p2.x, p2.y, x, y);
                if (!(dist < 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInside(Rectangle rect, int initialaxe, int finalaxe) {
        if (this.screenpositions != null) {
            for (int i = initialaxe; i <= finalaxe; ++i) {
                Point p = this.screenpositions[i];
                if (p.y < rect.y || p.y > rect.y + rect.height) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel() {
        return this.label;
    }

    public float[] getOriginalValues() {
        return this.originalvalues;
    }

    public float getKlass() {
        return this.klass;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public void calculateScreenPositions() {
        block5: {
            int i;
            float[] minvalues;
            float[] maxvalues;
            int space;
            int height;
            ParallelCoordinatesModel pmodel;
            block4: {
                this.screenpositions = new Point[this.originalvalues.length];
                pmodel = (ParallelCoordinatesModel)this.model;
                int width = pmodel.getSize().width - 20;
                height = pmodel.getSize().height - 60;
                space = width / this.originalvalues.length;
                maxvalues = pmodel.getMaxValues();
                minvalues = pmodel.getMinValues();
                if (pmodel.getNormalization() != ParallelCoordinatesModel.PolylineNormalizationType.COLUMN_INDEPENDENT) break block4;
                for (int i2 = 0; i2 < this.originalvalues.length; ++i2) {
                    this.screenpositions[i2] = new Point();
                    this.screenpositions[i2].x = 10 + i2 * space;
                    this.screenpositions[i2].y = 50 + height;
                    if (!(maxvalues[i2] > minvalues[i2])) continue;
                    this.screenpositions[i2].y = 50 + (int)((float)height * (1.0f - (this.originalvalues[i2] - minvalues[i2]) / (maxvalues[i2] - minvalues[i2])));
                }
                break block5;
            }
            if (pmodel.getNormalization() != ParallelCoordinatesModel.PolylineNormalizationType.COLUMN_ALL) break block5;
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (i = 0; i < maxvalues.length; ++i) {
                if (max < maxvalues[i]) {
                    max = maxvalues[i];
                }
                if (!(min > minvalues[i])) continue;
                min = minvalues[i];
            }
            for (i = 0; i < this.originalvalues.length; ++i) {
                this.screenpositions[i] = new Point();
                this.screenpositions[i].x = 10 + i * space;
                this.screenpositions[i].y = 50 + height;
                if (!(max > min)) continue;
                this.screenpositions[i].y = 50 + (int)((float)height * (1.0f - (this.originalvalues[i] - min) / (max - min)));
            }
        }
    }

    public void calculateColor() {
        ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)this.model;
        float maxklass = pmodel.getMaxKlass();
        float minklass = pmodel.getMinKlass();
        float colorindex = 0.0f;
        if (maxklass > minklass) {
            colorindex = (this.klass - minklass) / (maxklass - minklass);
        }
        this.color = pmodel.getColorTable().getColor(colorindex);
    }
}

