/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model;

import java.util.ArrayList;
import simpletree.model.AbstractInstance;
import simpletree.technique.parallelcoordinates.model.PolylineInstance;

public class Silhouette {
    public float calculate(ArrayList<AbstractInstance> instances, int[] indexes) {
        float silhouette = 0.0f;
        int size = instances.size();
        for (int i = 0; i < size; ++i) {
            float ai = 0.0f;
            float bi = Float.POSITIVE_INFINITY;
            int csize = 0;
            float[] value1 = ((PolylineInstance)instances.get(i)).getOriginalValues();
            float klass1 = ((PolylineInstance)instances.get(i)).getKlass();
            for (int j = 0; j < size; ++j) {
                float[] value2 = ((PolylineInstance)instances.get(j)).getOriginalValues();
                float klass2 = ((PolylineInstance)instances.get(j)).getKlass();
                if (klass1 == klass2) {
                    ai += this.distance(value1, value2, indexes);
                    ++csize;
                    continue;
                }
                bi = Math.min(bi, this.distance(value1, value2, indexes));
            }
            if (csize <= true) continue;
            silhouette += (bi - (ai /= (float)csize)) / Math.max(ai, bi);
        }
        return silhouette / (float)size;
    }

    private float distance(float[] v1, float[] v2, int[] indexes) {
        float dist = 0.0f;
        for (int index : indexes) {
            dist += (v1[index] - v2[index]) * (v1[index] - v2[index]);
        }
        return (float)Math.sqrt(dist);
    }
}

