/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModel;
import simpletree.technique.parallelcoordinates.model.view.ParallelCoordinatesFrame;

public class ParallelCoordinatesFrameOptions
extends JDialog {
    private ParallelCoordinatesFrame viewer;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JCheckBox colorInstancesCheckBox;
    private JPanel controlPanel;
    private JCheckBox drawAxeLabelsCheckBox;
    private JCheckBox drawSilhouetteCheckBox;
    private JCheckBox drawVerticalAxesCheckBox;
    private JCheckBox highQualityCheckBox;
    private JComboBox normComboBox;
    private JLabel normLabel;

    private ParallelCoordinatesFrameOptions(Frame parent) {
        super(parent, true);
        this.initComponents();
        for (ParallelCoordinatesModel.PolylineNormalizationType pn : ParallelCoordinatesModel.PolylineNormalizationType.values()) {
            this.normComboBox.addItem(pn);
        }
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.drawAxeLabelsCheckBox = new JCheckBox();
        this.drawSilhouetteCheckBox = new JCheckBox();
        this.drawVerticalAxesCheckBox = new JCheckBox();
        this.colorInstancesCheckBox = new JCheckBox();
        this.highQualityCheckBox = new JCheckBox();
        this.normLabel = new JLabel();
        this.normComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.controlPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.controlPanel.setLayout(new GridBagLayout());
        this.drawAxeLabelsCheckBox.setText("Draw axe labels");
        this.drawAxeLabelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.drawAxeLabelsCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.drawAxeLabelsCheckBox, gridBagConstraints);
        this.drawSilhouetteCheckBox.setText("Draw silhouette boxes");
        this.drawSilhouetteCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.drawSilhouetteCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.drawSilhouetteCheckBox, gridBagConstraints);
        this.drawVerticalAxesCheckBox.setText("Draw vertical axes");
        this.drawVerticalAxesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.drawVerticalAxesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.drawVerticalAxesCheckBox, gridBagConstraints);
        this.colorInstancesCheckBox.setText("Color non-selected instances");
        this.colorInstancesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.colorInstancesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.colorInstancesCheckBox, gridBagConstraints);
        this.highQualityCheckBox.setText("High quality renderer");
        this.highQualityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.highQualityCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.highQualityCheckBox, gridBagConstraints);
        this.normLabel.setText("Normalization");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.normLabel, gridBagConstraints);
        this.normComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.normComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPanel.add((Component)this.normComboBox, gridBagConstraints);
        this.getContentPane().add((Component)this.controlPanel, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrameOptions.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void drawAxeLabelsCheckBoxActionPerformed(ActionEvent evt) {
        ParallelCoordinatesModel model;
        if (this.viewer != null && (model = (ParallelCoordinatesModel)this.viewer.getModel()) != null) {
            model.setDrawAxeLabels(this.drawAxeLabelsCheckBox.isSelected());
            model.notifyObservers();
        }
    }

    private void drawVerticalAxesCheckBoxActionPerformed(ActionEvent evt) {
        ParallelCoordinatesModel model;
        if (this.viewer != null && (model = (ParallelCoordinatesModel)this.viewer.getModel()) != null) {
            model.setDrawVerticalAxes(this.drawVerticalAxesCheckBox.isSelected());
            model.notifyObservers();
        }
    }

    private void colorInstancesCheckBoxActionPerformed(ActionEvent evt) {
        ParallelCoordinatesModel model;
        if (this.viewer != null && (model = (ParallelCoordinatesModel)this.viewer.getModel()) != null) {
            model.setColoredInstances(this.colorInstancesCheckBox.isSelected());
            model.notifyObservers();
        }
    }

    private void drawSilhouetteCheckBoxActionPerformed(ActionEvent evt) {
        ParallelCoordinatesModel model;
        if (this.viewer != null && (model = (ParallelCoordinatesModel)this.viewer.getModel()) != null) {
            model.setDrawSilhouetteBoxes(this.drawSilhouetteCheckBox.isSelected());
            model.notifyObservers();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.viewer = null;
        this.setVisible(false);
    }

    private void highQualityCheckBoxActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setHighQualityRender(this.highQualityCheckBox.isSelected());
            this.viewer.updateImage();
        }
    }

    private void normComboBoxActionPerformed(ActionEvent evt) {
        ParallelCoordinatesModel model;
        if (this.viewer != null && (model = (ParallelCoordinatesModel)this.viewer.getModel()) != null) {
            model.setNormalization((ParallelCoordinatesModel.PolylineNormalizationType)((Object)this.normComboBox.getSelectedItem()));
            model.notifyObservers();
        }
    }

    public static ParallelCoordinatesFrameOptions getInstance(JFrame parent) {
        return new ParallelCoordinatesFrameOptions(parent);
    }

    public void display(ParallelCoordinatesFrame viewer) {
        if (viewer != null) {
            this.highQualityCheckBox.setSelected(viewer.isHighQualityRender());
            ParallelCoordinatesModel model = (ParallelCoordinatesModel)viewer.getModel();
            if (model != null) {
                this.drawAxeLabelsCheckBox.setSelected(model.isDrawAxeLabels());
                this.drawSilhouetteCheckBox.setSelected(model.isDrawSilhouetteBoxes());
                this.drawVerticalAxesCheckBox.setSelected(model.isDrawVerticalAxes());
                this.colorInstancesCheckBox.setSelected(model.isColoredInstances());
                this.normComboBox.setSelectedItem((Object)model.getNormalization());
            }
        }
        this.viewer = viewer;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

