/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.corpus.zip;

import java.io.IOException;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.corpus.zip.ZipCorpus;
import simpletree.textprocessing.corpus.zip.ZipCorpusParamView;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Text Processing", name="Zip File Corpus", description="Represents a set of text documents in a *.zip file.")
public class ZipCorpusComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient ZipCorpusParamView paramview;
    private String url = "";
    private int nrGrams = 1;
    private transient ZipCorpus corpus;

    public void execute() throws IOException {
        if (this.url.trim().length() <= 0) {
            throw new IOException("A corpus file name must be provided.");
        }
        this.corpus = new ZipCorpus(this.url, this.nrGrams);
    }

    public Corpus output() {
        return this.corpus;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new ZipCorpusParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.corpus = null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getNumberGrams() {
        return this.nrGrams;
    }

    public void setNumberGrams(int nrGrams) {
        this.nrGrams = nrGrams;
    }
}

