/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.corpus.zip;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.textprocessing.corpus.zip.ZipCorpusComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.ZIPFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class ZipCorpusParamView
extends AbstractParametersView {
    private ZipCorpusComp comp;
    private JButton corpusButton;
    private JLabel corpusLabel;
    private JTextField corpusTextField;
    private JComboBox gramsComboBox;
    private JLabel gramsLabel;

    public ZipCorpusParamView(ZipCorpusComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.corpusTextField = new JTextField();
        this.corpusButton = new JButton();
        this.corpusLabel = new JLabel();
        this.gramsLabel = new JLabel();
        this.gramsComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Zip Corpus"));
        this.setLayout(new GridBagLayout());
        this.corpusTextField.setColumns(35);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.corpusTextField, gridBagConstraints);
        this.corpusButton.setText("Search...");
        this.corpusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZipCorpusParamView.this.corpusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.corpusButton, gridBagConstraints);
        this.corpusLabel.setText("File name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.corpusLabel, gridBagConstraints);
        this.gramsLabel.setText("Number of grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.gramsLabel, gridBagConstraints);
        this.gramsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.gramsComboBox, gridBagConstraints);
    }

    private void corpusButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("textprocessing.properties");
            int result = OpenDialog.showOpenDialog(spm, new ZIPFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.corpusTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ZipCorpusParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.corpusTextField.setText(this.comp.getUrl());
        this.gramsComboBox.setSelectedIndex(this.comp.getNumberGrams() - 1);
    }

    public void finished() throws IOException {
        if (this.corpusTextField.getText().trim().length() <= 0) {
            throw new IOException("A corpus file name must be provided.");
        }
        this.comp.setUrl(this.corpusTextField.getText());
        this.comp.setNumberGrams(this.gramsComboBox.getSelectedIndex() + 1);
    }
}

