/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.textprocessing.processing.PreprocessorComp;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import simpletree.textprocessing.processing.view.LuhnCutAnalizer;
import vispipelinebasics.interfaces.AbstractParametersView;

public class PreprocessorParamView
extends AbstractParametersView {
    private PreprocessorComp comp;
    private JButton analyzeButton;
    private JComboBox gramsComboBox;
    private JLabel gramsLabel;
    private JLabel luhnLabel;
    private JTextField luhnLowerTextField;
    private JLabel luhnUpperLabel;
    private JTextField luhnUpperTextField;
    private JPanel preProcessingPanel;
    private JComboBox stemmerComboBox;
    private ButtonGroup wordsButtonGroup;

    public PreprocessorParamView(PreprocessorComp comp) {
        this.initComponents();
        this.comp = comp;
        for (StemmerFactory.StemmerType st : StemmerFactory.StemmerType.values()) {
            this.stemmerComboBox.addItem(st);
        }
        this.reset();
    }

    private void initComponents() {
        this.wordsButtonGroup = new ButtonGroup();
        this.preProcessingPanel = new JPanel();
        this.luhnLabel = new JLabel();
        this.gramsComboBox = new JComboBox();
        this.gramsLabel = new JLabel();
        this.luhnLowerTextField = new JTextField();
        this.analyzeButton = new JButton();
        this.luhnUpperLabel = new JLabel();
        this.luhnUpperTextField = new JTextField();
        this.stemmerComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Corpus Pre-processing"));
        this.setLayout(new GridBagLayout());
        this.preProcessingPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.preProcessingPanel.setLayout(new GridBagLayout());
        this.luhnLabel.setText("Luhn's lower cut");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnLabel, gridBagConstraints);
        this.gramsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        this.gramsComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsComboBox, gridBagConstraints);
        this.gramsLabel.setText("Number of grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsLabel, gridBagConstraints);
        this.luhnLowerTextField.setColumns(5);
        this.luhnLowerTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnLowerTextField, gridBagConstraints);
        this.analyzeButton.setText("Analyze");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreprocessorParamView.this.analyzeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.analyzeButton, gridBagConstraints);
        this.luhnUpperLabel.setText("Luhn's upper cut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnUpperLabel, gridBagConstraints);
        this.luhnUpperTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnUpperTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.stemmerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add(this.preProcessingPanel, gridBagConstraints);
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        if (this.comp.getCorpus() != null) {
            LuhnCutAnalizer analizer = LuhnCutAnalizer.getInstance(null);
            analizer.display(this.comp.getCorpus(), (StemmerFactory.StemmerType)((Object)this.stemmerComboBox.getSelectedItem()), this.gramsComboBox.getSelectedIndex() + 1);
            this.luhnLowerTextField.setText(Integer.toString(analizer.getLowerCut()));
            this.luhnUpperTextField.setText(Integer.toString(analizer.getUpperCut()));
        }
    }

    public void reset() {
        this.stemmerComboBox.setSelectedItem((Object)this.comp.getStemmer());
        this.luhnLowerTextField.setText(Integer.toString(this.comp.getLowerCut()));
        if (this.comp.getUpperCut() > -1) {
            this.luhnUpperTextField.setText(Integer.toString(this.comp.getUpperCut()));
        } else {
            this.luhnUpperTextField.setText("");
        }
        this.gramsComboBox.setSelectedIndex(this.comp.getNumberGrams() - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finished() throws IOException {
        this.comp.setStemmer((StemmerFactory.StemmerType)((Object)this.stemmerComboBox.getSelectedItem()));
        if (this.luhnLowerTextField.getText().trim().length() > 0) {
            if (Integer.parseInt(this.luhnLowerTextField.getText()) <= -1) throw new IOException("The Luhn's lower cut should be positive.");
            this.comp.setLowerCut(Integer.parseInt(this.luhnLowerTextField.getText()));
        } else {
            this.comp.setLowerCut(1);
        }
        if (this.luhnUpperTextField.getText().trim().length() > 0) {
            if (Integer.parseInt(this.luhnUpperTextField.getText()) <= -1) throw new IOException("The Luhn's upper cut should be positive.");
            this.comp.setUpperCut(Integer.parseInt(this.luhnUpperTextField.getText()));
            return;
        } else {
            this.comp.setUpperCut(-1);
        }
    }
}

