/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.util.PropertiesManager;

public class Stopword {
    private ArrayList<String> stopwords = new ArrayList();
    private static Stopword instance;

    private Stopword() {
    }

    public static Stopword getInstance() throws IOException {
        if (instance == null) {
            PropertiesManager spm = PropertiesManager.getInstance("textprocessing.properties");
            String filename = spm.getProperty("SPW.FILE");
            instance = new Stopword();
            if (Stopword.class.getClassLoader().getResource(filename) != null) {
                try {
                    File file = new File(Stopword.class.getClassLoader().getResource(filename).toURI());
                    if (!file.isDirectory() && file.exists()) {
                        instance.readStopwordList(file);
                    } else {
                        Logger.getLogger(Stopword.class.getName()).log(Level.SEVERE, "ERROR: stopwords file not found: " + filename);
                    }
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(Stopword.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return instance;
    }

    public void changeStopwordList(String filename) throws IOException {
        this.stopwords = new ArrayList();
        File file = new File(filename);
        if (!file.isDirectory() && file.exists()) {
            this.readStopwordList(file);
        } else {
            Logger.getLogger(Stopword.class.getName()).log(Level.SEVERE, "ERROR: stopwords file not found: " + filename);
        }
    }

    public void changeStopwordList(ArrayList<String> words) {
        this.stopwords = words;
    }

    public List<String> getStopwordList() {
        return this.stopwords;
    }

    public void addStopwords(List<String> stopwords) {
        for (String stopword : stopwords) {
            if (this.stopwords.contains(stopword.toLowerCase())) continue;
            this.stopwords.add(stopword.toLowerCase());
        }
        Collections.sort(this.stopwords);
    }

    public void removeStopword(String stopword) {
        this.stopwords.remove(stopword);
    }

    public void saveStopwordsList(String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (String stopword : this.stopwords) {
                out.write(stopword);
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Problems saving \"" + filename + "\" file!");
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public boolean isStopWord(String word) {
        return Collections.binarySearch(this.stopwords, word) >= 0;
    }

    private void readStopwordList(File file) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                this.stopwords.add(line.toLowerCase());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + file.getAbsolutePath() + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + file.getAbsolutePath() + "\"");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        Collections.sort(this.stopwords);
    }
}

