/*
 * Decompiled with CFR 0.152.
 */
package simpletree.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.processing.Ngram;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;

public class PExTopic {
    private static final float percentageTerms = 0.5f;
    private static boolean firstTopic;
    private static float maxcov;

    public static Map<String, Float> createTopic(SimpleTreeModel stModel, ArrayList<AbstractInstance> vertex, Corpus corpus) {
        try {
            int lowercut = 2;
            int uppercut = -1;
            int ngrams = 1;
            if (vertex.size() > 50 && vertex.size() < 100) {
                lowercut = 10;
            } else if (vertex.size() > 100 && vertex.size() < 300) {
                lowercut = 15;
            } else if (vertex.size() > 300) {
                lowercut = 20;
            }
            Preprocessor pp = new Preprocessor(corpus);
            AbstractMatrix matrix = pp.getMatrixSelected(lowercut, uppercut, ngrams, StemmerFactory.StemmerType.NONE, vertex);
            ArrayList<Ngram> cpNgrams = pp.getNgrams();
            if (matrix.getRowCount() > 0 && matrix.getDimensions() > 0) {
                ArrayList<String> attributes = new ArrayList<String>();
                float[][] points = PExTopic.cutDimensions(matrix, cpNgrams, attributes);
                return PExTopic.createTopic(points, attributes, vertex);
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(PExTopic.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static float[][] cutDimensions(AbstractMatrix matrix, ArrayList<Ngram> cpNgrams, ArrayList<String> indexGrams) {
        int i;
        float[][] newpoints = new float[matrix.getRowCount()][];
        for (i = 0; i < newpoints.length; ++i) {
            newpoints[i] = new float[matrix.getDimensions() < 200 ? matrix.getDimensions() : 200];
            float[] point = matrix.getRow(i).toArray();
            for (int j = 0; j < newpoints[i].length; ++j) {
                newpoints[i][j] = point[j];
            }
        }
        indexGrams.clear();
        for (i = 0; i < newpoints[0].length; ++i) {
            indexGrams.add(cpNgrams.get((int)i).ngram);
        }
        return newpoints;
    }

    private static Map<String, Float> createTopic(float[][] points, ArrayList<String> attributes, ArrayList<AbstractInstance> vertex) throws IOException {
        int j;
        int i;
        float[] mean = new float[points[0].length];
        Arrays.fill(mean, 0.0f);
        for (i = 0; i < points.length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                int n = j;
                mean[n] = mean[n] + points[i][j];
            }
        }
        i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / (float)points.length;
        }
        for (i = 0; i < points.length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                float[] fArray = points[i];
                int n = j;
                fArray[n] = fArray[n] - mean[j];
            }
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        return PExTopic.getTerms(points, attributes, indexes);
    }

    private static Map<String, Float> getTerms(float[][] points, ArrayList<String> attributes, ArrayList<Integer> indexes) {
        float aux;
        HashMap<String, Float> terms = new HashMap<String, Float>();
        float gcov1 = Float.MIN_VALUE;
        int icov = 0;
        int jcov = 0;
        for (int i = 0; i < points[0].length - 1; ++i) {
            for (int j = points[0].length - 1; j > i; --j) {
                if (indexes.contains(i) || indexes.contains(j) || !(gcov1 < (aux = PExTopic.covariance(points, i, j)))) continue;
                gcov1 = aux;
                icov = i;
                jcov = j;
            }
        }
        indexes.add(icov);
        indexes.add(jcov);
        if (attributes.size() > 0) {
            terms.put(attributes.get(icov), Float.valueOf(gcov1));
            terms.put(attributes.get(jcov), Float.valueOf(gcov1));
            String msg = "(" + attributes.get(icov).replaceAll("<>", "") + "," + attributes.get(jcov).replaceAll("<>", "") + ",";
            for (int i = 0; i < points[0].length - 1; ++i) {
                if (indexes.contains(i) || !((aux = (PExTopic.covariance(points, icov, i) + PExTopic.covariance(points, jcov, i)) / 2.0f) / gcov1 > 0.5f)) continue;
                terms.put(attributes.get(i), Float.valueOf(aux / gcov1));
                msg = msg + attributes.get(i).replaceAll("<>", "") + ",";
                indexes.add(i);
            }
            return terms;
        }
        return null;
    }

    private static float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)points.length;
    }
}

