/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;

public class ProjectionUtil {
    public static AbstractMatrix modelToMatrix(ProjectionModel model, Scalar scalar) {
        DenseMatrix matrix = new DenseMatrix();
        ArrayList<String> attr = new ArrayList<String>();
        attr.add("x");
        attr.add("y");
        matrix.setAttributes(attr);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<AbstractInstance> instances = model.getInstances();
        for (int i = 0; i < instances.size(); ++i) {
            ProjectionInstance ins = (ProjectionInstance)instances.get(i);
            float[] vect = new float[]{ins.getX(), ins.getY()};
            matrix.addRow(new DenseVector(vect, ins.getId(), ins.getScalarValue(scalar)));
            labels.add(ins.toString());
        }
        matrix.setLabels(labels);
        return matrix;
    }

    public static void importScalars(ProjectionModel model, String filename) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            ArrayList<String> scalars = new ArrayList<String>();
            int linenumber = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                ++linenumber;
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    scalars.add(t.nextToken().trim());
                }
                break block9;
            }
            HashMap<Integer, AbstractInstance> index = new HashMap<Integer, AbstractInstance>();
            for (AbstractInstance pi : model.getInstances()) {
                index.put(pi.getId(), pi);
            }
            while ((line = in.readLine()) != null) {
                ++linenumber;
                ArrayList<Float> values = new ArrayList<Float>();
                if (line.trim().length() <= 0 || line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, ";", false);
                String fname = t.nextToken().trim();
                while (t.hasMoreTokens()) {
                    float value = Float.parseFloat(t.nextToken().trim());
                    values.add(Float.valueOf(value));
                }
                if (scalars.size() != values.size()) {
                    throw new IOException("The number of values for one scalar does not match with the number of declared scalars.\r\nCheck line " + linenumber + " of the file.");
                }
                AbstractInstance pi = (AbstractInstance)index.get(Integer.parseInt(fname));
                if (pi == null) continue;
                for (int i = 0; i < scalars.size(); ++i) {
                    Scalar s = model.addScalar((String)scalars.get(i));
                    ((ProjectionInstance)pi).setScalarValue(s, ((Float)values.get(i)).floatValue());
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void exportScalars(ProjectionModel model, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < model.getScalars().size(); ++i) {
                out.write(model.getScalars().get(i).getName().replaceAll(";", "_"));
                if (i >= model.getScalars().size() - 1) continue;
                out.write(";");
            }
            out.write("\r\n");
            for (AbstractInstance pi : model.getInstances()) {
                out.write(pi.getId() + ";");
                for (int i = 0; i < model.getScalars().size(); ++i) {
                    float scalar = ((ProjectionInstance)pi).getScalarValue(model.getScalars().get(i));
                    out.write(Float.toString(scalar).replaceAll(";", "_"));
                    if (i >= model.getScalars().size() - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void log(boolean console, boolean file) throws IOException {
        int i;
        Handler[] handlers;
        Logger rootLogger;
        String filename = "log%g.txt";
        int limit = 10000000;
        int numLogFiles = 5;
        if (file) {
            FileHandler handler = new FileHandler(filename, limit, numLogFiles, true);
            handler.setFormatter(new SimpleFormatter());
            handler.setLevel(Level.ALL);
            Logger.getLogger("").addHandler(handler);
            Logger.getLogger("Util").log(Level.INFO, "Adding the file logging.");
        } else {
            Logger.getLogger("Util").log(Level.INFO, "Removing the file logging.");
            rootLogger = Logger.getLogger("");
            handlers = rootLogger.getHandlers();
            for (i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof FileHandler)) continue;
                rootLogger.removeHandler(handlers[i]);
            }
        }
        if (console) {
            rootLogger = Logger.getLogger("");
            handlers = rootLogger.getHandlers();
            for (i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                rootLogger.removeHandler(handlers[i]);
            }
            rootLogger.addHandler(new ConsoleHandler());
            Logger.getLogger("Util").log(Level.INFO, "Adding console logging.");
        } else {
            Logger.getLogger("Util").log(Level.INFO, "Removing console logging.");
            rootLogger = Logger.getLogger("");
            handlers = rootLogger.getHandlers();
            for (i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                rootLogger.removeHandler(handlers[i]);
            }
        }
    }
}

