/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.util.ArrayList;
import java.util.HashMap;
import simpletree.model.Edge;
import simpletree.util.PairDistance;

public class TreeDistanceCalculator {
    private HashMap<Integer, Integer> nodesHeight = new HashMap();
    private HashMap<Integer, PairDistance> parentAndDists = new HashMap();

    public float getDistance(ArrayList<Edge> edges, int node1, int node2, boolean useWeights) {
        int nodeLevel1 = this.getNodeHeight(edges, node1);
        int nodeLevel2 = this.getNodeHeight(edges, node2);
        float dist1 = 0.0f;
        float dist2 = 0.0f;
        while (nodeLevel1 > 0 && nodeLevel2 > 0) {
            PairDistance dists;
            if (nodeLevel1 > nodeLevel2) {
                dists = this.getParentAndDistParent(edges, node1);
                node1 = dists.id;
                dist1 = useWeights ? (dist1 += dists.dist) : (dist1 += 1.0f);
                --nodeLevel1;
                continue;
            }
            if (nodeLevel2 > nodeLevel1) {
                dists = this.getParentAndDistParent(edges, node2);
                node2 = dists.id;
                dist2 = useWeights ? (dist2 += dists.dist) : (dist2 += 1.0f);
                --nodeLevel2;
                continue;
            }
            if (node1 == node2) {
                return dist1 + dist2;
            }
            PairDistance dists1 = this.getParentAndDistParent(edges, node1);
            node1 = dists1.id;
            dist1 = useWeights ? (dist1 += dists1.dist) : (dist1 += 1.0f);
            PairDistance dists2 = this.getParentAndDistParent(edges, node2);
            node2 = dists2.id;
            dist2 = useWeights ? (dist2 += dists2.dist) : (dist2 += 1.0f);
            --nodeLevel1;
            --nodeLevel2;
        }
        if (node1 == node2) {
            return dist1 + dist2;
        }
        return -1.0f;
    }

    private int getNodeHeight(ArrayList<Edge> edges, int node) {
        if (this.nodesHeight.containsKey(node)) {
            return this.nodesHeight.get(node);
        }
        int level = 0;
        Edge edge = this.getTargetEdge(edges, node);
        while (edge != null) {
            ++level;
            edge = this.getTargetEdge(edges, edge.getSource());
        }
        this.nodesHeight.put(node, level);
        return level;
    }

    private Edge getTargetEdge(ArrayList<Edge> edges, int target) {
        for (int i = 0; i < edges.size(); ++i) {
            if (edges.get(i).getTarget() != target) continue;
            return edges.get(i);
        }
        return null;
    }

    private PairDistance getParentAndDistParent(ArrayList<Edge> edges, int target) {
        if (this.parentAndDists.containsKey(target)) {
            return this.parentAndDists.get(target);
        }
        PairDistance ret = new PairDistance();
        Edge e = this.getTargetEdge(edges, target);
        if (e != null) {
            ret.id = e.getSource();
            ret.dist = e.getWeight();
            this.parentAndDists.put(target, ret);
            return ret;
        }
        return null;
    }
}

