/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import simpletree.model.AbstractInstance;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.processing.view.BrowserControl;

public class MultipleFileView
extends JDialog {
    private FilePane showedFilePane = null;
    private final int numberCharsAtTabTitle = 20;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel dataPanel;
    private JTabbedPane fileviewTabbedPane;
    private JButton highlightButton;
    private JLabel highlightLabel;
    private JPanel highlightPanel;
    private JTextField highlightTextField;
    private JToolBar highlightToolBar;

    private MultipleFileView(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.dataPanel = new JPanel();
        this.fileviewTabbedPane = new JTabbedPane();
        this.highlightToolBar = new JToolBar();
        this.highlightPanel = new JPanel();
        this.highlightLabel = new JLabel();
        this.highlightTextField = new JTextField();
        this.highlightButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("File Multiple View");
        this.setModal(true);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleFileView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.dataPanel.setLayout(new BorderLayout());
        this.fileviewTabbedPane.setMinimumSize(new Dimension(1000, 500));
        this.fileviewTabbedPane.setPreferredSize(new Dimension(800, 500));
        this.fileviewTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MultipleFileView.this.fileviewTabbedPaneStateChanged(evt);
            }
        });
        this.dataPanel.add((Component)this.fileviewTabbedPane, "Center");
        this.highlightPanel.setLayout(new FlowLayout(2));
        this.highlightLabel.setText("Highlight");
        this.highlightPanel.add(this.highlightLabel);
        this.highlightTextField.setColumns(20);
        this.highlightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MultipleFileView.this.highlightTextFieldKeyPressed(evt);
            }
        });
        this.highlightPanel.add(this.highlightTextField);
        this.highlightButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/TipOfTheDay16.gif")));
        this.highlightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleFileView.this.highlightButtonActionPerformed(evt);
            }
        });
        this.highlightPanel.add(this.highlightButton);
        this.highlightToolBar.add(this.highlightPanel);
        this.dataPanel.add((Component)this.highlightToolBar, "South");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.pack();
    }

    private void fileviewTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.fileviewTabbedPane.getSelectedComponent() instanceof FilePane) {
            this.showedFilePane = (FilePane)this.fileviewTabbedPane.getSelectedComponent();
            if (this.showedFilePane != null && this.highlightTextField.getText().trim().length() > 0) {
                this.showedFilePane.highlight(this.showedFilePane.textArea, this.highlightTextField.getText().trim());
            }
        }
    }

    private void highlightTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.showedFilePane != null && this.highlightTextField.getText().trim().length() > 0) {
            this.showedFilePane.highlight(this.showedFilePane.textArea, this.highlightTextField.getText().trim());
        }
    }

    private void highlightButtonActionPerformed(ActionEvent evt) {
        if (this.showedFilePane != null && this.highlightTextField.getText().trim().length() > 0) {
            this.showedFilePane.highlight(this.showedFilePane.textArea, this.highlightTextField.getText().trim());
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static MultipleFileView getInstance(JFrame parent) {
        return new MultipleFileView(parent);
    }

    public void display(ArrayList<AbstractInstance> instances, Corpus corpus) {
        this.fileviewTabbedPane.removeAll();
        this.highlightTextField.setText("");
        if (instances != null) {
            for (AbstractInstance ai : instances) {
                String label = ai.toString();
                if (label.length() > 20) {
                    label = label.substring(0, 17) + "...";
                }
                this.fileviewTabbedPane.addTab(label, new FilePane(ai.toString(), corpus, ai.getId()));
            }
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void display(AbstractInstance instance, Corpus corpus) {
        ArrayList<AbstractInstance> aux = new ArrayList<AbstractInstance>();
        aux.add(instance);
        this.display(aux, corpus);
    }

    class FilePane
    extends JPanel {
        private JTextField filelabelField;
        private JPanel filelabelPanel;
        private JEditorPane textArea;
        private JScrollPane textAreaScrollPane;
        private Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(Color.YELLOW);

        public FilePane(String label, Corpus corpus, int id) {
            this.initComponents(label, corpus, id);
        }

        private void initComponents(String label, Corpus corpus, int id) {
            this.textAreaScrollPane = new JScrollPane();
            this.textArea = new JEditorPane();
            this.filelabelPanel = new JPanel();
            this.filelabelField = new JTextField();
            this.setLayout(new BorderLayout());
            this.textAreaScrollPane.setBorder(BorderFactory.createTitledBorder("File Content"));
            this.textAreaScrollPane.setAutoscrolls(true);
            this.textArea.setEditable(false);
            this.textArea.setAutoscrolls(false);
            this.textAreaScrollPane.setViewportView(this.textArea);
            this.add((Component)this.textAreaScrollPane, "Center");
            this.textArea.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserControl.displayURL(e.getURL().toString());
                    }
                }
            });
            this.filelabelPanel.setLayout(new BorderLayout());
            this.filelabelPanel.setBorder(BorderFactory.createTitledBorder("File Label"));
            this.filelabelField.setEditable(false);
            this.filelabelPanel.add((Component)this.filelabelField, "Center");
            this.add((Component)this.filelabelPanel, "North");
            this.filelabelField.setText(label);
            this.filelabelField.setCaretPosition(0);
            try {
                this.textArea.setText(corpus.getViewContent(id));
                this.textArea.setCaretPosition(0);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void highlight(JTextComponent textComp, String pattern) {
            this.removeHighlights(textComp);
            try {
                Highlighter hilite = textComp.getHighlighter();
                Document doc = textComp.getDocument();
                String text = doc.getText(0, doc.getLength()).toLowerCase();
                int pos = 0;
                pos = text.indexOf(pattern.toLowerCase(), pos);
                if (pos >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                    this.textArea.setCaretPosition(pos);
                    pos += pattern.length();
                }
                while ((pos = text.indexOf(pattern.toLowerCase(), pos)) >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                    pos += pattern.length();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void removeHighlights(JTextComponent textComp) {
            Highlighter hilite = textComp.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
        }

        class MyHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public MyHighlightPainter(Color color) {
                super(color);
            }
        }
    }
}

