/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.coordination.AbstractCoordinator;
import simpletree.model.ProjectionModel;
import simpletree.view.ProjectionFrame;
import simpletree.view.ProjectionFrameParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.View", name="Projection View Frame", description="Display a projection model.")
public class ProjectionFrameComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String title = "";
    private Dimension size = new Dimension(600, 600);
    private transient ProjectionModel model;
    private transient ProjectionFrameParamView paramview;
    private transient ArrayList<AbstractCoordinator> coordinators;

    public void execute() throws IOException {
        if (this.model != null) {
            ProjectionFrame frame = new ProjectionFrame();
            frame.setSize(this.size);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
            frame.setTitle(this.title);
            frame.setModel(this.model);
            if (this.coordinators != null) {
                for (int i = 0; i < this.coordinators.size(); ++i) {
                    frame.addCoordinator(this.coordinators.get(i));
                }
            }
        } else {
            throw new IOException("A projection model should be provided.");
        }
    }

    public void input(@Param(name="projection model") ProjectionModel model) {
        this.model = model;
    }

    public void attach(@Param(name="Coordinator") AbstractCoordinator coordinator) {
        if (this.coordinators == null) {
            this.coordinators = new ArrayList();
        }
        if (coordinator != null) {
            this.coordinators.add(coordinator);
        }
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new ProjectionFrameParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
        this.coordinators = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public Dimension getSize() {
        return this.size;
    }
}

