/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ThumbnailPanel
extends JPanel {
    private BufferedImage thumbnailImage;
    private JFrame referenceFrame;
    private JPanel drawPanel;
    private JLabel headerLabel;
    private JPanel headerPanel;

    public ThumbnailPanel(JFrame referenceFrame) {
        this.initComponents();
        this.referenceFrame = referenceFrame;
    }

    public void setImage(BufferedImage image) {
        this.thumbnailImage = image;
    }

    public void drawPanelPaint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float aspect = 0.0f;
        if (this.thumbnailImage.getHeight() >= this.thumbnailImage.getWidth()) {
            aspect = (float)this.thumbnailImage.getWidth() / (float)this.thumbnailImage.getHeight();
            this.setPreferredSize(new Dimension((int)(300.0f * aspect), 330));
            this.revalidate();
            g2.drawImage(this.thumbnailImage, 0, 0, this.drawPanel.getWidth(), this.drawPanel.getHeight(), this.drawPanel);
        } else {
            aspect = (float)this.thumbnailImage.getHeight() / (float)this.thumbnailImage.getWidth();
            this.setPreferredSize(new Dimension(300, (int)(330.0f * aspect)));
            this.revalidate();
            g2.drawImage(this.thumbnailImage, 0, 0, this.drawPanel.getWidth(), this.drawPanel.getHeight(), this.drawPanel);
        }
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.headerLabel = new JLabel();
        this.drawPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                ThumbnailPanel.this.drawPanelPaint(g);
            }
        };
        this.setBackground(new Color(0, 0, 0));
        this.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204), 2));
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(300, 330));
        this.setLayout(new GridBagLayout());
        this.headerPanel.setBackground(new Color(204, 204, 204));
        this.headerPanel.setMinimumSize(new Dimension(30, 30));
        this.headerPanel.setPreferredSize(new Dimension(300, 30));
        this.headerPanel.setLayout(new BorderLayout());
        this.headerLabel.setFont(new Font("Tahoma", 1, 11));
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setText("Upper Level Tree");
        this.headerPanel.add((Component)this.headerLabel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.headerPanel, gridBagConstraints);
        this.drawPanel.setBackground(new Color(255, 255, 255));
        this.drawPanel.setMinimumSize(new Dimension(30, 30));
        this.drawPanel.setPreferredSize(new Dimension(300, 300));
        this.drawPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ThumbnailPanel.this.drawPanelMouseClicked(evt);
            }
        });
        GroupLayout drawPanelLayout = new GroupLayout(this.drawPanel);
        this.drawPanel.setLayout(drawPanelLayout);
        drawPanelLayout.setHorizontalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 326, Short.MAX_VALUE));
        drawPanelLayout.setVerticalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.drawPanel, gridBagConstraints);
    }

    private void drawPanelMouseClicked(MouseEvent evt) {
        this.referenceFrame.setVisible(true);
        this.referenceFrame.toFront();
    }
}

