/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class TreeRadialPie {
    private final SimpleTreeModel model;
    private List<PieSector> sectors;
    public static float border = 20.0f;
    public static float thickness = 20.0f;
    public float radius;
    public Point pieCenter;
    public float alpha = 1.0f;

    public TreeRadialPie(SimpleTreeModel model) {
        this.model = model;
        this.sectors = new ArrayList<PieSector>();
    }

    public void setSelectedSectors(List<Integer> ids) {
        for (Integer id : ids) {
            PieSector sector = this.getSectorById(id);
            if (sector == null) continue;
            sector.selected = true;
        }
    }

    private PieSector getSectorById(int id) {
        PieSector piesector = null;
        for (PieSector sec : this.sectors) {
            if (sec.id != id) continue;
            piesector = sec;
        }
        return piesector;
    }

    public void build() {
        this.alpha = this.model.getAlpha();
        Rectangle modelBB = this.model.getBoundingBox();
        this.pieCenter = new Point(modelBB.x + modelBB.width / 2, modelBB.y + modelBB.height / 2);
        ProjectionInstance leafInst = null;
        for (AbstractInstance abstractInstance : this.model.getInstances()) {
            if (((SimpleTreeInstance)abstractInstance).getNumChildren() != 0) continue;
            leafInst = (SimpleTreeInstance)abstractInstance;
            break;
        }
        this.radius = (float)Math.sqrt(Math.pow((float)this.pieCenter.x - leafInst.getX(), 2.0) + Math.pow((float)this.pieCenter.y - leafInst.getY(), 2.0)) + border;
        ArrayList<SimpleTreeInstance> validInstances = new ArrayList<SimpleTreeInstance>();
        for (AbstractInstance inst : this.model.getInstances()) {
            if (!((SimpleTreeInstance)inst).isValid()) continue;
            validInstances.add((SimpleTreeInstance)inst);
        }
        Collections.sort(validInstances, new Comparator(){

            public int compare(Object o1, Object o2) {
                SimpleTreeInstance sti1 = (SimpleTreeInstance)o1;
                SimpleTreeInstance sti2 = (SimpleTreeInstance)o2;
                return Float.compare(sti1.angleRightBorder, sti2.angleRightBorder);
            }
        });
        float f = this.radius;
        float externalRadius = this.radius + thickness;
        for (int i = 0; i < validInstances.size(); ++i) {
            SimpleTreeInstance inst = (SimpleTreeInstance)validInstances.get(i);
            double sinAngle = Math.sin((double)(-inst.angleRightBorder - inst.reservedAngle) * Math.PI / 180.0);
            double cosAngle = Math.cos((double)(-inst.angleRightBorder - inst.reservedAngle) * Math.PI / 180.0);
            PieSector internalArc = new PieSector(new Ellipse2D.Double((float)this.pieCenter.x - f, (float)this.pieCenter.y - f, 2.0 * (double)f, 2.0 * (double)f));
            PieSector externalArc = new PieSector(new Arc2D.Double((float)this.pieCenter.x - externalRadius, (float)this.pieCenter.y - externalRadius, 2.0f * externalRadius, 2.0f * externalRadius, -inst.angleRightBorder, -inst.reservedAngle, 2));
            externalArc.subtract(internalArc);
            externalArc.color = inst.getColor();
            externalArc.id = inst.getId();
            externalArc.label = inst.toString();
            externalArc.startAngle = inst.angleRightBorder;
            externalArc.totalAngle = inst.reservedAngle;
            externalArc.selected = inst.isSelected();
            this.sectors.add(externalArc);
        }
    }

    public Rectangle getBoundingBox() {
        return new Rectangle((int)((float)this.pieCenter.x - this.radius), (int)((float)this.pieCenter.y - this.radius), (int)(this.radius * 2.0f), (int)(this.radius * 2.0f));
    }

    public static Rectangle computeBoundingBox(SimpleTreeModel stModel) {
        Rectangle modelBB = stModel.getBoundingBox();
        Point modelCenter = new Point(modelBB.x + modelBB.width / 2, modelBB.y + modelBB.height / 2);
        double ellipseRadius = (float)Math.sqrt(Math.pow(modelBB.width / 2, 2.0) + Math.pow(modelBB.height / 2, 2.0)) + border;
        return new Rectangle((int)((double)modelCenter.x - ellipseRadius - (double)thickness), (int)((double)modelCenter.y - ellipseRadius - (double)thickness), (int)(ellipseRadius * 2.0 + (double)thickness), (int)(ellipseRadius * 2.0 + (double)thickness));
    }

    public void draw(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float internalRadius = this.radius;
        float externalRadius = this.radius + thickness;
        for (PieSector sector : this.sectors) {
            if (sector.selected) {
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
            }
            g2.setColor(sector.color);
            g2.fill(sector);
            g2.setColor(Color.BLACK);
            Point p1 = new Point((int)(Math.cos((double)sector.startAngle * Math.PI / 180.0) * (double)externalRadius), (int)(Math.sin((double)sector.startAngle * Math.PI / 180.0) * (double)externalRadius));
            Point p2 = new Point((int)(Math.cos((double)sector.startAngle * Math.PI / 180.0) * ((double)internalRadius * 1.005)), (int)(Math.sin((double)sector.startAngle * Math.PI / 180.0) * ((double)internalRadius * 1.005)));
            g2.drawLine(p1.x + this.pieCenter.x, p1.y + this.pieCenter.y, p2.x + this.pieCenter.x, p2.y + this.pieCenter.y);
        }
        internalRadius = (float)((double)internalRadius * 1.001);
        PieSector internalArc = new PieSector(new Ellipse2D.Double((float)this.pieCenter.x - internalRadius, (float)this.pieCenter.y - internalRadius, 2.0 * (double)internalRadius, 2.0 * (double)internalRadius));
        PieSector externalArc = new PieSector(new Ellipse2D.Double((float)this.pieCenter.x - externalRadius, (float)this.pieCenter.y - externalRadius, 2.0 * (double)externalRadius, 2.0 * (double)externalRadius));
        g2.setStroke(new BasicStroke(2.0f));
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setColor(Color.WHITE);
        g2.draw(externalArc);
        g2.draw(internalArc);
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setColor(Color.black);
        g2.draw(externalArc);
        g2.draw(internalArc);
    }

    public void draw(BufferedImage img) {
        Graphics2D g2 = img.createGraphics();
        this.draw(g2);
    }

    private double radiusFromModelBoundindBox() {
        Rectangle modelBB = this.model.getBoundingBox();
        double boundingBoxRadius = Math.sqrt(Math.pow(modelBB.width / 2, 2.0) + Math.pow(modelBB.height / 2, 2.0)) + (double)border;
        return boundingBoxRadius;
    }

    public class PieSector
    extends Area {
        public int id;
        public float startAngle;
        public float totalAngle;
        public String label;
        public Color color;
        public boolean selected;

        public PieSector(Shape s) {
            super(s);
        }
    }
}

