/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.model.AbstractInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.forms.MatrixView;
import simpletree.view.interaction.TreeAbstractSelection;

public class MatrixViewSelection
extends TreeAbstractSelection {
    private SimpleTreeFrame frame;

    public MatrixViewSelection(ModelViewer viewer) {
        super(viewer);
        this.frame = (SimpleTreeFrame)viewer;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.frame.getModel() == null || this.frame.getMatrix() == null) {
            JOptionPane.showMessageDialog(this.frame, "You must first provide a matrix to the view componet", "Error", 0);
            return;
        }
        if (this.viewer.getModel() != null) {
            if (selinst.size() == 1) {
                selinst = MatrixViewSelection.selectHierarchy((SimpleTreeInstance)selinst.get(0));
            }
            AbstractMatrix matrix = this.frame.getMatrix();
            try {
                AbstractMatrix newMatrix = this.getSubMatrix(matrix, selinst);
                MatrixView sMatrix = new MatrixView(this.frame);
                sMatrix.refreshTableData(newMatrix);
                sMatrix.setVisible(true);
                this.frame.getModel().setSelectedInstances(selinst);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(MatrixViewSelection.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(MatrixViewSelection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private AbstractMatrix getSubMatrix(AbstractMatrix matrix, ArrayList<AbstractInstance> selinst) throws CloneNotSupportedException, IOException {
        ArrayList<String> labels = new ArrayList<String>();
        AbstractMatrix newMatrix = MatrixFactory.getInstance(matrix.getClass());
        for (AbstractInstance instance : selinst) {
            int id = instance.getId();
            int instanceIndex = matrix.getIds().indexOf(id);
            if (instanceIndex == -1) continue;
            String label = matrix.getLabels().get(instanceIndex);
            labels.add(label);
            AbstractVector vector = (AbstractVector)matrix.getRow(instanceIndex).clone();
            newMatrix.addRow(vector);
        }
        newMatrix.setLabels(labels);
        newMatrix.setAttributes(matrix.getAttributes());
        return newMatrix;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/resources/Table16.png"));
    }

    @Override
    public String toString() {
        return "Attributes Visualization";
    }
}

