/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.view.ModelViewer;
import simpletree.view.interaction.TreeAbstractSelection;

public class NodeNeighborsSelection
extends TreeAbstractSelection {
    private HashSet<SimpleTreeInstance> neighborsSet;
    private HashSet<SimpleTreeInstance> borderSet;
    private SimpleTreeModel model;
    private int neighborsToSelect = 12;

    public NodeNeighborsSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (selinst.size() == 1) {
            this.model = (SimpleTreeModel)this.viewer.getModel();
            SimpleTreeInstance treeInstance = (SimpleTreeInstance)selinst.get(0);
            ArrayList<AbstractInstance> nodeNeighbors = this.getNodeNeighbors(treeInstance, this.getNeighborsToSelect());
            this.viewer.getModel().setSelectedInstances(nodeNeighbors);
            for (int i = 0; i < this.viewer.getCoordinators().size(); ++i) {
                this.viewer.getCoordinators().get(i).coordinate(selinst, null);
            }
            this.viewer.getModel().notifyObservers();
        }
    }

    private List<SimpleTreeInstance> getNodeParents(SimpleTreeInstance node, int levels) {
        SimpleTreeInstance parent;
        LinkedList<SimpleTreeInstance> parentList = new LinkedList<SimpleTreeInstance>();
        for (int i = 0; i < levels && (parent = this.model.getInstanceById(node.getParent())) != null; ++i) {
            parentList.add(parent);
            node = parent;
        }
        if (this.model.getInstanceById(node.getParent()) != null) {
            this.borderSet.add(this.model.getInstanceById(node.getParent()));
        }
        return parentList;
    }

    private ArrayList<SimpleTreeInstance> getNodeChildren(SimpleTreeInstance node, int levels) {
        SimpleTreeInstance child;
        int childId;
        int i;
        ArrayList<SimpleTreeInstance> childList = new ArrayList<SimpleTreeInstance>();
        if (!node.hasChildren() || levels < 0) {
            return new ArrayList<SimpleTreeInstance>();
        }
        if (levels > 0) {
            for (i = 0; i < node.getNumChildren(); ++i) {
                childId = node.getChildrenId(i);
                if (childId == -1 || this.neighborsSet.contains(child = this.model.getInstanceById(childId))) continue;
                this.neighborsSet.add(child);
                childList.add(child);
                childList.addAll(this.getNodeChildren(child, levels - 1));
            }
        }
        if (levels == 0) {
            for (i = 0; i < node.getNumChildren(); ++i) {
                childId = node.getChildrenId(i);
                if (childId == -1) continue;
                child = this.model.getInstanceById(childId);
                this.borderSet.add(child);
            }
        }
        return childList;
    }

    private ArrayList<AbstractInstance> getNodeNeighbors(SimpleTreeInstance node, int levels) {
        this.neighborsSet = new HashSet();
        this.borderSet = new HashSet();
        this.neighborsSet.add(node);
        List<SimpleTreeInstance> parentList = this.getNodeParents(node, levels);
        int currentLevel = levels - 1;
        for (SimpleTreeInstance parent : parentList) {
            this.neighborsSet.add(parent);
            this.neighborsSet.addAll(this.getNodeChildren(parent, currentLevel--));
        }
        this.neighborsSet.addAll(this.getNodeChildren(node, levels));
        return new ArrayList<AbstractInstance>(this.neighborsSet);
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif"));
    }

    @Override
    public String toString() {
        return "Node Neighbors Selection";
    }

    public int getNeighborsToSelect() {
        return this.neighborsToSelect;
    }

    public void setNeighborsToSelect(int neighborsToSelect) {
        this.neighborsToSelect = neighborsToSelect;
    }
}

