/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.topic.TopicOutline;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.interaction.TreeAbstractSelection;

public class SubTreePolygonSelection
extends TreeAbstractSelection {
    public SimpleTreeInstance subtreeRoot;
    public SimpleTreeFrame frame;

    public SubTreePolygonSelection(ModelViewer viewer) {
        super(viewer);
        this.frame = (SimpleTreeFrame)viewer;
        this.subtreeRoot = null;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        TopicOutline outline = new TopicOutline();
        outline.setPadding(0.06);
        outline.setSamplingDistance(0.01);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        ArrayList<Integer> nodeIds = new ArrayList<Integer>();
        for (AbstractInstance ai : selinst) {
            SimpleTreeInstance stInst = (SimpleTreeInstance)ai;
            stInst.setSelected(true);
            points.add(new Point2D.Double(stInst.getX(), stInst.getY()));
            nodeIds.add(stInst.getId());
        }
        points.addAll(this.sampleEdges(nodeIds));
        outline.compute(points, this.frame.getView().getSize());
        outline.pointsIds = nodeIds;
        SimpleTreeFrame stFrame = (SimpleTreeFrame)this.viewer;
        stFrame.setOutlineTopic(outline);
    }

    private List<Point2D> sampleEdges(List<Integer> nodeIds) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        SimpleTreeModel stModel = (SimpleTreeModel)this.viewer.getModel();
        for (Edge e : stModel.getSelectedConnectivity().getEdges()) {
            if (!nodeIds.contains(e.getSource()) || !nodeIds.contains(e.getTarget())) continue;
            SimpleTreeInstance srcInst = stModel.getInstanceById(e.getSource());
            SimpleTreeInstance tgtInst = stModel.getInstanceById(e.getTarget());
            points.add(new Point2D.Float((srcInst.getX() + tgtInst.getX()) / 2.0f, (srcInst.getY() + tgtInst.getY()) / 2.0f));
        }
        return points;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/resources/pie16.png"));
    }

    @Override
    public String toString() {
        return "SubTree polygon";
    }
}

