/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.SimpleTreeUtil;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.interaction.TreeAbstractSelection;

public class TreeBranchZoomSelection
extends TreeAbstractSelection {
    private static int zoomFrameCount = 1;

    public TreeBranchZoomSelection(ModelViewer viewer) {
        super(viewer);
    }

    public static void updateParentInstancePosition(SimpleTreeFrame parentFrame, SimpleTreeFrame childFrame) {
        if (parentFrame == null) {
            return;
        }
        SimpleTreeModel parentModel = (SimpleTreeModel)parentFrame.getModel();
        SimpleTreeModel childModel = (SimpleTreeModel)childFrame.getModel();
        Rectangle thisArea = TreeBranchZoomSelection.getInstancesBox(childModel.getInstances(), childModel);
        Rectangle parentArea = TreeBranchZoomSelection.getInstancesBox(childModel.getInstances(), parentModel);
        float aspect = (float)thisArea.width / (float)thisArea.height;
        parentArea = SimpleTreeUtil.TransformRectangle(parentArea, aspect);
        for (AbstractInstance ai : childModel.getInstances()) {
            SimpleTreeInstance sti = (SimpleTreeInstance)ai;
            float newX = (sti.getX() - (float)thisArea.x) / (float)thisArea.width;
            float newY = (sti.getY() - (float)thisArea.y) / (float)thisArea.height;
            SimpleTreeInstance parentInstance = parentModel.getInstanceById(sti.getId());
            if (parentInstance == null) continue;
            parentInstance.setX((float)parentArea.width * newX + (float)parentArea.x);
            parentInstance.setY((float)parentArea.height * newY + (float)parentArea.y);
        }
        if (parentFrame.getParentFrame() != null) {
            TreeBranchZoomSelection.updateParentInstancePosition(parentFrame.getParentFrame(), parentFrame);
        }
        TreeBranchZoomSelection.setHighlightArea(parentFrame, childFrame);
    }

    public static void setHighlightArea(SimpleTreeFrame parentFrame, SimpleTreeFrame childFrame) {
        if (parentFrame != null && childFrame != null) {
            for (SimpleTreeFrame parentFrameAux = parentFrame; parentFrameAux != null; parentFrameAux = parentFrameAux.getParentFrame()) {
                Rectangle childArea = TreeBranchZoomSelection.getInstancesBox(childFrame.getModel().getInstances(), (SimpleTreeModel)parentFrameAux.getModel());
                parentFrameAux.setHighlightShape(childArea);
                SimpleTreeModel parentModel = (SimpleTreeModel)parentFrameAux.getModel();
                parentModel.setChanged();
                parentModel.notifyObservers();
            }
        }
    }

    public static void updateParentInstancePosition(SimpleTreeFrame parentFrame, SimpleTreeFrame childFrame, SimpleTreeInstance instance, Point2D.Float offset) {
        if (parentFrame == null) {
            return;
        }
        SimpleTreeModel parentModel = (SimpleTreeModel)parentFrame.getModel();
        SimpleTreeModel childModel = (SimpleTreeModel)childFrame.getModel();
        Rectangle parentArea = TreeBranchZoomSelection.getInstancesBox(childModel.getInstances(), parentModel);
        Dimension thisArea = childModel.getSize();
        float xScale = (float)parentArea.width / (float)(thisArea.width - 30);
        float yScale = (float)parentArea.height / (float)(thisArea.height - 30);
        SimpleTreeInstance parentInstance = parentModel.getInstanceById(instance.getId());
        if (parentInstance == null) {
            return;
        }
        parentInstance.setX(offset.x * xScale + parentInstance.getX());
        parentInstance.setY(offset.y * yScale + parentInstance.getY());
        Rectangle childArea = TreeBranchZoomSelection.getInstancesBox(childModel.getInstances(), parentModel);
        parentFrame.setHighlightShape(childArea);
        parentModel.setChanged();
        parentModel.notifyObservers();
        Point2D.Float newOffset = new Point2D.Float(parentInstance.getX(), parentInstance.getY());
        newOffset.x = parentInstance.getX() - newOffset.x;
        newOffset.y = parentInstance.getY() - newOffset.y;
        TreeBranchZoomSelection.updateParentInstancePosition(parentFrame.getParentFrame(), parentFrame, parentInstance, newOffset);
    }

    public static Rectangle getInstancesBox(ArrayList<AbstractInstance> instanceList, SimpleTreeModel treeModel) {
        if (instanceList == null) {
            return null;
        }
        float minX = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        for (AbstractInstance childInstance : instanceList) {
            SimpleTreeInstance instance = treeModel.getInstanceById(childInstance.getId());
            if (instance == null) continue;
            if (minX > instance.getX()) {
                minX = instance.getX();
            }
            if (maxX < instance.getX()) {
                maxX = instance.getX();
            }
            if (minY > instance.getY()) {
                minY = instance.getY();
            }
            if (!(maxY < instance.getY())) continue;
            maxY = instance.getY();
        }
        Rectangle rect = new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
        return rect;
    }

    private SimpleTreeModel getNewModel(SimpleTreeModel model, ArrayList<AbstractInstance> instances) {
        ArrayList<Edge> edges;
        Scalar scalar;
        SimpleTreeModel newModel = new SimpleTreeModel();
        ArrayList<Scalar> sc = new ArrayList<Scalar>();
        for (int i = 0; i < model.getScalars().size(); ++i) {
            scalar = new Scalar(model.getScalars().get(i).getName());
            scalar.store(model.getScalars().get(i).getMin());
            scalar.store(model.getScalars().get(i).getMax());
            sc.add(scalar);
        }
        newModel.setScalars(sc);
        int pos = model.getScalars().indexOf(model.getSelectedScalar());
        if (pos == -1) {
            scalar = new Scalar(model.getSelectedScalar().getName());
            scalar.store(model.getSelectedScalar().getMin());
            scalar.store(model.getSelectedScalar().getMax());
            newModel.setSelectedScalar(scalar);
        } else {
            newModel.setSelectedScalar(sc.get(pos));
        }
        newModel.setLabels(model.getLabels());
        ArrayList<AbstractInstance> inst = new ArrayList<AbstractInstance>();
        for (int i = 0; i < instances.size(); ++i) {
            SimpleTreeInstance ti = ((SimpleTreeInstance)instances.get(i)).createClone(newModel);
            ti.setModel(newModel);
            inst.add(ti);
        }
        newModel.setMatrix(((SimpleTreeFrame)this.viewer).getMatrix());
        newModel.setInstances(inst);
        newModel.setRoot(instances.get(0).getId());
        newModel.setAlpha(model.getAlpha());
        newModel.setColortable(model.getColorTable());
        newModel.setType(model.getType());
        SimpleTreeConnectivity conn = model.getSelectedConnectivity();
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        if (conn != null && (edges = conn.getEdges()) != null) {
            for (int i = 0; i < edges.size(); ++i) {
                if (!this.isInInstances(instances, edges.get(i).getSource()) || !this.isInInstances(instances, edges.get(i).getTarget())) continue;
                newEdges.add(new Edge(edges.get(i).getSource(), edges.get(i).getTarget(), edges.get(i).getWeight()));
            }
        }
        SimpleTreeConnectivity newCon = new SimpleTreeConnectivity(conn.getName(), newEdges);
        ArrayList<Connectivity> conns = newModel.getConnectivities();
        pos = -1;
        for (int i = 0; i < model.getConnectivities().size(); ++i) {
            if (!model.getConnectivities().get(i).equals(conn)) {
                ArrayList<Edge> edges2 = new ArrayList<Edge>();
                for (int j = 0; j < model.getConnectivities().get(i).getEdges().size(); ++j) {
                    edges2.add(new Edge(model.getConnectivities().get(i).getEdges().get(i).getSource(), model.getConnectivities().get(i).getEdges().get(i).getTarget()));
                }
                SimpleTreeConnectivity c = new SimpleTreeConnectivity(model.getConnectivities().get(i).getName(), edges2);
                conns.add(c);
                continue;
            }
            pos = i;
        }
        if (pos != -1) {
            if (pos == conns.size()) {
                conns.add(newCon);
            } else {
                conns.add(pos, newCon);
            }
        }
        newModel.setSelectedConnectivity(newCon);
        newModel.setInstanceSize(model.getInstanceSize());
        newModel.setImageCollectionPath(model.getImageCollectionPath());
        newModel.setClassMap(model.getClassMap());
        newModel.setMultiscaleParams(model.getMultiscaleParams());
        return newModel;
    }

    protected boolean isInInstances(ArrayList<AbstractInstance> instances, int id) {
        for (int i = 0; i < instances.size(); ++i) {
            if (instances.get(i).getId() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null) {
            SimpleTreeModel simpleTreeModel = (SimpleTreeModel)this.viewer.getModel();
            ArrayList<AbstractInstance> instances = new ArrayList<AbstractInstance>();
            if (selinst.size() == 1) {
                instances = TreeBranchZoomSelection.selectHierarchy((SimpleTreeInstance)selinst.get(0));
            } else {
                instances.addAll(selinst);
            }
            SimpleTreeModel newModel = this.getNewModel(simpleTreeModel, instances);
            if (this.viewer instanceof SimpleTreeFrame) {
                SimpleTreeFrame treeFrame = new SimpleTreeFrame();
                treeFrame.setParentFrame((SimpleTreeFrame)this.viewer);
                treeFrame.setSize(600, 600);
                treeFrame.setDefaultCloseOperation(2);
                treeFrame.setVisible(true);
                treeFrame.setTitle(((SimpleTreeFrame)this.viewer).getTitle() + " (zoom" + zoomFrameCount + ")");
                ++zoomFrameCount;
                treeFrame.setModel(newModel);
                treeFrame.setLabelSize(((SimpleTreeFrame)this.viewer).getLabelSize());
                ((SimpleTreeFrame)this.viewer).setSubFrameVariables(treeFrame);
                if (this.viewer.getCoordinators() != null) {
                    for (int i = 0; i < this.viewer.getCoordinators().size(); ++i) {
                        treeFrame.addCoordinator(this.viewer.getCoordinators().get(i));
                    }
                }
            }
            selinst.clear();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Zoom16.gif"));
    }

    @Override
    public String toString() {
        return "Tree Branch Zoom";
    }
}

