/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.interaction.TreeClassAbstractSelection;

public class TreeClassSelection
extends TreeClassAbstractSelection {
    private Scalar ncdata = null;
    private float indexCdata = 0.0f;
    private int indexScalar;

    public TreeClassSelection(ModelViewer viewer) {
        super(viewer);
    }

    public boolean isElement(ArrayList<Scalar> scalars, String name) {
        if (scalars == null || scalars.isEmpty()) {
            return false;
        }
        for (int i = 0; i < scalars.size(); ++i) {
            if (!scalars.get(i).getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected void setClass(ArrayList<AbstractInstance> selinst) {
        ProjectionInstance pi;
        int i;
        if (((ProjectionModel)this.viewer.getModel()).getScalars().indexOf(this.ncdata) == -1) {
            this.ncdata = null;
        }
        if (this.ncdata == null) {
            while (this.isElement(((ProjectionModel)this.viewer.getModel()).getScalars(), "New Class " + this.indexScalar)) {
                ++this.indexScalar;
            }
            this.ncdata = ((ProjectionModel)this.viewer.getModel()).addScalar("New Class " + this.indexScalar);
            ++this.indexScalar;
            this.indexCdata = 0.0f;
            for (i = 0; i < this.viewer.getModel().getInstances().size(); ++i) {
                pi = (SimpleTreeInstance)this.viewer.getModel().getInstances().get(i);
                pi.setScalarValue(this.ncdata, this.indexCdata);
            }
            this.indexCdata += 1.0f;
        }
        for (i = 0; i < selinst.size(); ++i) {
            pi = (ProjectionInstance)selinst.get(i);
            pi.setScalarValue(this.ncdata, this.indexCdata);
        }
        this.indexCdata += 1.0f;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null) {
            ArrayList<AbstractInstance> instances = new ArrayList<AbstractInstance>();
            if (selinst.size() == 1) {
                instances = TreeClassSelection.selectHierarchy((SimpleTreeInstance)selinst.get(0));
            } else {
                instances.addAll(selinst);
            }
            this.setClass(instances);
            ((SimpleTreeFrame)this.viewer).updateScalars(this.ncdata);
            this.viewer.getModel().setSelectedInstances(instances);
            this.viewer.getModel().notifyObservers();
        }
    }

    public void setNcdata(Scalar c) {
        this.ncdata = c;
    }

    public Scalar getNcdata() {
        return this.ncdata;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignCenter16.gif"));
    }

    @Override
    public String toString() {
        return "Class Selection";
    }

    @Override
    public void reset() {
        this.ncdata = null;
        this.indexScalar = 1;
    }
}

