/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.view.ModelViewer;
import simpletree.view.interaction.TreeAbstractSelection;

public class TreeDistanceSelection
extends TreeAbstractSelection {
    private double distance = 0.3f;
    private SimpleTreeModel treeModel;

    public TreeDistanceSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null) {
            this.treeModel = (SimpleTreeModel)this.viewer.getModel();
            if (selinst.size() == 1) {
                selinst = this.selectInDistance((SimpleTreeInstance)selinst.get(0));
            }
            this.viewer.getModel().setSelectedInstances(selinst);
            for (int i = 0; i < this.viewer.getCoordinators().size(); ++i) {
                this.viewer.getCoordinators().get(i).coordinate(selinst, null);
            }
            this.viewer.getModel().notifyObservers();
        }
    }

    private ArrayList<AbstractInstance> selectInDistance(AbstractInstance instance) {
        SimpleTreeModel model = (SimpleTreeModel)this.viewer.getModel();
        SimpleTreeInstance treeInst = model.getInstanceById(instance.getId());
        ArrayList<Edge> allEdges = model.getSelectedConnectivity().getEdges();
        HashSet<AbstractInstance> visitedVertices = new HashSet<AbstractInstance>();
        visitedVertices.add(instance);
        Set<AbstractInstance> toSelect = this.distanceDepthSearch(allEdges, treeInst, visitedVertices, this.distance);
        toSelect.add(instance);
        return new ArrayList<AbstractInstance>(toSelect);
    }

    private Set<AbstractInstance> distanceDepthSearch(List<Edge> allEdges, AbstractInstance v, Set<AbstractInstance> visitedVertices, double currDistance) {
        HashSet<AbstractInstance> neighborsToSelect = new HashSet<AbstractInstance>();
        List<Edge> vertexEdges = this.getNodeEdges(v, allEdges);
        for (Edge e : vertexEdges) {
            SimpleTreeInstance neighbor = null;
            if (e.getSource() != v.getId()) {
                neighbor = this.treeModel.getInstanceById(e.getSource());
            } else if (e.getTarget() != v.getId()) {
                neighbor = this.treeModel.getInstanceById(e.getTarget());
            }
            if (visitedVertices.contains(neighbor) || !((double)e.getWeight() < currDistance)) continue;
            neighborsToSelect.add(neighbor);
            visitedVertices.add(neighbor);
            neighborsToSelect.addAll(this.distanceDepthSearch(allEdges, neighbor, visitedVertices, currDistance - (double)e.getWeight()));
        }
        return neighborsToSelect;
    }

    public List<Edge> getNodeEdges(AbstractInstance instance, List<Edge> edges) {
        ArrayList<Edge> validEdges = new ArrayList<Edge>();
        for (Edge e : edges) {
            if (e.getSource() != instance.getId() && e.getTarget() != instance.getId()) continue;
            validEdges.add(e);
        }
        return validEdges;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif"));
    }

    @Override
    public String toString() {
        return "Graph Distance Select";
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }
}

