/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.MultiscaleParams;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.datamining.clustering.multiscale.ClusterIO;
import simpletree.datamining.clustering.multiscale.MultiscaleData;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.layout.radial.RadialLayoutComp;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelComp;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.ImageContent;
import simpletree.model.content.LabelContent;
import simpletree.technique.msnj.MultiScaleNJ;
import simpletree.technique.msnj.MultiScaleNJConnectionComp;
import simpletree.textprocessing.corpus.folder.FolderCorpus;
import simpletree.util.SimpleTreeUtil;
import simpletree.view.ModelViewer;
import simpletree.view.ProgressDialog;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.SimpleTreeFrameComp;
import simpletree.view.selection.AbstractSelection;

public class TreeMultiscaleExpandSelection
extends AbstractSelection
implements Runnable {
    private final SimpleTreeFrame frame;
    private ExpansionType expansionType = ExpansionType.EXTERNAL;
    private int minClusterSize = 4;
    private int levelsToExpand = 1;
    private Thread thread;
    private ProgressDialog progressDialog;
    private BufferedImage modelSnapshot;
    private ClusterSimpleTreeInstance clickedInstance;

    public TreeMultiscaleExpandSelection(ModelViewer viewer) {
        super(viewer);
        this.frame = (SimpleTreeFrame)viewer;
        this.clickedInstance = null;
    }

    public ExpansionType getExpansionType() {
        return this.expansionType;
    }

    public void setExpansionType(ExpansionType expansionType) {
        this.expansionType = expansionType;
    }

    private SimpleTree getNodeTree(ClusterSimpleTreeInstance clusterInstance, SimpleTreeModel treeModel) throws IOException {
        TreeCluster treeCluster = clusterInstance.getTreeCluster();
        if (treeCluster != null) {
            String newickTree = treeCluster.getNewick();
            if ((newickTree == null || newickTree.isEmpty()) && treeModel.getSupertreeFile() != null) {
                treeCluster = treeModel.getSupertreeFile().Cluster.load(clusterInstance.getId());
                clusterInstance.setTreeCluster(treeCluster);
            }
            SimpleTree nodeTree = new SimpleTree(treeCluster.getNewick());
            if (treeModel.getSupertreeFile() != null) {
                SimpleTreeUtil.convertToSuperTree(nodeTree, treeCluster, this.levelsToExpand, this.minClusterSize, treeModel.getSupertreeFile());
            } else {
                SimpleTreeUtil.convertToSuperTree(nodeTree, treeCluster, this.levelsToExpand, this.minClusterSize, this.frame.treeScalars);
            }
            nodeTree.generateEdges();
            SupertreeFile stFile = treeModel.getSupertreeFile();
            LabelContent labelContent = new LabelContent();
            HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
            for (ContentSimpleTree treeNode : nodeTree.getNodes()) {
                if (!treeNode.isValid()) continue;
                if (treeNode instanceof ClusterContentSimpleTree) {
                    List<Integer> medoids = ((ClusterContentSimpleTree)treeNode).getTreeCluster().getMedoidList();
                    int firstMedoidId = medoids.get(0);
                    if (stFile != null) {
                        treeNode.setKlass(stFile.Scalar.getById(firstMedoidId));
                    } else {
                        treeNode.setKlass(this.frame.treeScalars.get(firstMedoidId));
                    }
                    if (stFile != null && stFile.Label.hasLabels()) {
                        labelMap.put(treeNode.getId(), stFile.Label.getById(firstMedoidId));
                        for (Integer medoidId : medoids) {
                            labelMap.put(medoidId, stFile.Label.getById(medoidId));
                        }
                        continue;
                    }
                    if (this.frame.treeLabels == null || this.frame.treeLabels.getLabels().size() <= 0) continue;
                    labelMap.put(treeNode.getId(), this.frame.treeLabels.get(firstMedoidId));
                    for (Integer medoidId : medoids) {
                        labelMap.put(medoidId, this.frame.treeLabels.get(medoidId));
                    }
                    continue;
                }
                float klass = 0.0f;
                klass = stFile != null ? stFile.Scalar.getById(treeNode.getId()) : this.frame.treeScalars.get(treeNode.getId());
                treeNode.setKlass(klass);
                String label = null;
                label = stFile != null ? stFile.Label.getById(treeNode.getId()) : this.frame.treeLabels.get(treeNode.getId());
                if (label != null) {
                    labelMap.put(treeNode.getId(), label);
                    continue;
                }
                labelMap.put(treeNode.getId(), "");
            }
            labelContent.setMap(labelMap);
            nodeTree.setLabelContent(labelContent);
            return nodeTree;
        }
        int maxId = Integer.MIN_VALUE;
        for (AbstractInstance instance : this.frame.getModel().getInstances()) {
            if (instance.getId() <= maxId) continue;
            maxId = instance.getId();
        }
        Cluster nodeCluster = clusterInstance.getCluster();
        if (nodeCluster.getSubClusterList().isEmpty() && !nodeCluster.getItemList().isEmpty()) {
            MultiscaleParams msParams = treeModel.getMultiscaleParams();
            msParams.setMaxId(maxId + 1);
            MultiScaleNJ msNJ = new MultiScaleNJ(msParams.isPromotion(), msParams.getType(), msParams.getDissType(), msParams.getMaxId());
            SimpleTree nodeTree = msNJ.execute(nodeCluster, this.frame.getMatrix(), false, msParams);
            nodeTree.setMultiScaleParams(msParams);
            return nodeTree;
        }
        if (!nodeCluster.getSubClusterList().isEmpty() && nodeCluster.getItemList().isEmpty()) {
            List<Cluster> subClusterList;
            HashMap<Integer, Long> clusterMap = this.frame.getClusterData().getMap();
            if (clusterMap != null && !clusterMap.isEmpty()) {
                subClusterList = new ArrayList<Cluster>();
                String clusterFilePath = this.frame.getClusterData().getFilename();
                for (Cluster subCluster : nodeCluster.getSubClusterList()) {
                    long subClusterPosition = (Long)clusterMap.get(subCluster.getId());
                    Cluster newSubCluster = ClusterIO.readBinaryCluster(clusterFilePath, subClusterPosition, true);
                    subClusterList.add(newSubCluster);
                }
            } else {
                subClusterList = nodeCluster.getSubClusterList();
            }
            MultiScaleNJConnectionComp msComp = new MultiScaleNJConnectionComp();
            msComp.input(this.frame.getMatrix(), new MultiscaleData(this.frame.getClusterData().getMap(), subClusterList));
            msComp.setMaxId(maxId + 1);
            msComp.setCreateSingleRoot(true);
            msComp.execute();
            SimpleTree nodeTree = msComp.output();
            treeModel.getMultiscaleParams().setMaxId(maxId + 1);
            return nodeTree;
        }
        if (this.frame.getClusterData() == null) {
            JOptionPane.showMessageDialog(this.frame, "You must first link a ClusterDataset to this Frame", "SubTree build fail", 0);
            return null;
        }
        ArrayList<Cluster> subClusterList = new ArrayList();
        HashMap<Integer, Long> clusterMap = this.frame.getClusterData().getMap();
        if (clusterMap == null || clusterMap.isEmpty()) {
            subClusterList = nodeCluster.getSubClusterList();
        } else {
            String clusterFilePath = this.frame.getClusterData().getFilename();
            for (Cluster subCluster : nodeCluster.getSubClusterList()) {
                long subClusterPosition = clusterMap.get(subCluster.getId());
                Cluster newSubCluster = ClusterIO.readBinaryCluster(clusterFilePath, subClusterPosition, true);
                subClusterList.add(newSubCluster);
            }
        }
        MultiScaleNJConnectionComp msComp = new MultiScaleNJConnectionComp();
        msComp.input(this.frame.getMatrix(), new MultiscaleData(this.frame.getClusterData().getMap(), subClusterList));
        msComp.setMaxId(maxId + 1);
        msComp.setCreateSingleRoot(true);
        msComp.execute();
        SimpleTree nodeTree = msComp.output();
        treeModel.getMultiscaleParams().setMaxId(maxId + 1);
        return nodeTree;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (selinst == null || selinst.isEmpty()) {
            return;
        }
        SimpleTreeModel treeModel = (SimpleTreeModel)this.frame.getModel();
        for (AbstractInstance inst : selinst) {
            if (!(inst instanceof ClusterSimpleTreeInstance)) continue;
            this.clickedInstance = (ClusterSimpleTreeInstance)inst;
            treeModel.setSelectedInstance(this.clickedInstance);
            break;
        }
        if (this.clickedInstance == null) {
            return;
        }
        treeModel.setHighLightInstanceId(this.clickedInstance.getId());
        this.modelSnapshot = this.frame.getSnapshot();
        Graphics2D g2 = this.modelSnapshot.createGraphics();
        this.clickedInstance.drawHighlight(g2, true);
        this.thread = new Thread(this);
        this.progressDialog = new ProgressDialog(this.thread);
        this.progressDialog.setText("Expanding supernode " + this.clickedInstance.getId());
        this.progressDialog.pack();
        this.progressDialog.setVisible(true);
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    private void localTreeExpansion(SimpleTreeModel newModel, SimpleTreeModel intoModel, SimpleTreeInstance intoInstance) {
        intoModel.appendTree(newModel, intoInstance.getId(), false);
        LabelContent labels = (LabelContent)intoModel.getContent(AbstractContent.Type.LABEL);
        LabelContent newLabels = (LabelContent)newModel.getContent(AbstractContent.Type.LABEL);
        labels.getMap().putAll(newLabels.getMap());
        this.frame.setModel(intoModel);
        this.frame.updateScalars(newModel.getSelectedScalar());
        intoModel.setChanged();
        intoModel.notifyObservers();
    }

    private void externalTreeExpansion(SimpleTreeModel newModel, SimpleTreeModel parentModel, ClusterSimpleTreeInstance instance) throws IOException {
        RadialLayoutComp layoutComp = new RadialLayoutComp();
        layoutComp.input(newModel);
        layoutComp.execute();
        newModel.setScalars(parentModel.getScalars());
        newModel.setColortable(parentModel.getColorTable());
        newModel.setImages(parentModel.getImages());
        if (parentModel.getCorpus() instanceof FolderCorpus) {
            String url = parentModel.getCorpus().getUrl();
            FolderCorpus fc = new FolderCorpus(url, 1);
            newModel.setCorpus(fc);
        } else {
            newModel.setCorpus(parentModel.getCorpus());
        }
        newModel.setMultiScaleLevel(parentModel.getMultiScaleLevel() + 1);
        newModel.setSupertreeFile(parentModel.getSupertreeFile());
        RadialLayoutComp rc = new RadialLayoutComp();
        rc.input(newModel);
        rc.execute();
        SimpleTreeFrameComp stcf = new SimpleTreeFrameComp();
        stcf.input(rc.output());
        stcf.input(this.frame.getMatrix());
        stcf.input(this.frame.getClusterData());
        stcf.setParentFrame(this.frame);
        stcf.setParentClusterId(instance.getId());
        String label = instance.getId() + "";
        SimpleTreeFrame highestParent = this.frame;
        while (highestParent.getParentFrame() != null) {
            highestParent = highestParent.getParentFrame();
        }
        stcf.setTitle(highestParent.getTitle() + ", Cluster: " + instance.getId() + ", Instance: " + label + ", Multi-Scale Tree Level: " + newModel.getMultiScaleLevel());
        stcf.execute();
        SimpleTreeFrame newFrame = stcf.getCurrentFrame();
        newFrame.addThumbnail(this.modelSnapshot, this.frame);
        newFrame.rootCluster = this.frame.rootCluster;
        newFrame.treeLabels = this.frame.treeLabels;
        newFrame.treeScalars = this.frame.treeScalars;
        newFrame.treeTopics = this.frame.treeTopics;
        if (parentModel.getContent(AbstractContent.Type.IMAGE) != null) {
            ImageContent parentImageContent = (ImageContent)parentModel.getContent(AbstractContent.Type.IMAGE);
            LabelContent labels = (LabelContent)newModel.getContent(AbstractContent.Type.LABEL);
            ImageContent imageContent = new ImageContent(labels, parentImageContent.path);
            newModel.addContent(imageContent);
        }
        this.frame.setSubFrameVariables(stcf.getCurrentFrame());
        this.frame.changeStatus("Number of Instances in Selection: " + newModel.getInstances().size());
        newModel.setChanged();
        newModel.notifyObservers();
    }

    @Override
    public ImageIcon getIcon() {
        URL ic = this.getClass().getResource("/resources/expand16_2.png");
        if (ic == null) {
            ic = this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif");
        }
        return new ImageIcon(ic);
    }

    @Override
    public String toString() {
        return "Expand Super Node";
    }

    @Override
    public void run() {
        long initTime = System.currentTimeMillis();
        SimpleTreeModel treeModel = (SimpleTreeModel)this.frame.getModel();
        try {
            SimpleTree nodeTree = this.getNodeTree(this.clickedInstance, treeModel);
            if (nodeTree == null) {
                return;
            }
            if (Thread.interrupted()) {
                return;
            }
            SimpleTreeModelComp stc = new SimpleTreeModelComp();
            stc.input(nodeTree);
            stc.execute();
            SimpleTreeModel subModel = stc.output();
            subModel.setSupertreeFile(treeModel.getSupertreeFile());
            subModel.setMatrix(this.frame.getMatrix());
            if (this.getExpansionType() == ExpansionType.LOCAL) {
                this.localTreeExpansion(subModel, treeModel, this.clickedInstance);
            } else if (this.getExpansionType() == ExpansionType.EXTERNAL) {
                this.externalTreeExpansion(subModel, treeModel, this.clickedInstance);
            }
            subModel.notifyObservers();
            this.progressDialog.setVisible(false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Error on opening cluster tree");
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        long diffTime = endTime - initTime;
        System.out.printf("Total time expanding node #%d -> %f seconds.\n", this.clickedInstance.getId(), Float.valueOf((float)diffTime / 1000.0f));
    }

    public static enum ExpansionType {
        LOCAL,
        EXTERNAL;

    }
}

