/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.interaction.TreeAbstractSelection;

public class TreeSplitSelection
extends TreeAbstractSelection {
    public TreeSplitSelection(ModelViewer viewer) {
        super(viewer);
    }

    protected boolean isInInstances(ArrayList<AbstractInstance> instances, int id) {
        for (int i = 0; i < instances.size(); ++i) {
            if (instances.get(i).getId() != id) continue;
            return true;
        }
        return false;
    }

    protected SimpleTreeModel getNewModel(SimpleTreeModel model, ArrayList<AbstractInstance> instances) {
        ArrayList<Edge> edges;
        int i;
        Scalar scalar;
        SimpleTreeModel newModel = new SimpleTreeModel();
        ArrayList<Scalar> sc = new ArrayList<Scalar>();
        for (int i2 = 0; i2 < model.getScalars().size(); ++i2) {
            scalar = new Scalar(model.getScalars().get(i2).getName());
            scalar.store(model.getScalars().get(i2).getMin());
            scalar.store(model.getScalars().get(i2).getMax());
            sc.add(scalar);
        }
        newModel.setScalars(sc);
        int pos = model.getScalars().indexOf(model.getSelectedScalar());
        if (pos == -1) {
            scalar = new Scalar(model.getSelectedScalar().getName());
            scalar.store(model.getSelectedScalar().getMin());
            scalar.store(model.getSelectedScalar().getMax());
            newModel.setSelectedScalar(scalar);
        } else {
            newModel.setSelectedScalar(sc.get(pos));
        }
        ArrayList<AbstractInstance> inst = new ArrayList<AbstractInstance>();
        for (i = 0; i < instances.size(); ++i) {
            SimpleTreeInstance ti = ((SimpleTreeInstance)instances.get(i)).createClone(newModel);
            ti.setModel(newModel);
            inst.add(ti);
        }
        newModel.setLabels(model.getLabels());
        for (i = 0; i < inst.size(); ++i) {
            SimpleTreeInstance nti = (SimpleTreeInstance)inst.get(i);
            SimpleTreeInstance ti = model.getInstanceById(nti.getId());
            if (ti == null || !ti.hasChildren()) continue;
            for (int j = 0; j < ti.getNumChildren(); ++j) {
                SimpleTreeInstance tic = model.getInstanceById(ti.getChildrenId(j));
                SimpleTreeInstance ntic = newModel.getInstanceById(tic.getId());
                if (ntic == null) continue;
                if (nti.getChildrenId(0) == -1) {
                    nti.setChildrenId(0, ntic.getId());
                    continue;
                }
                nti.setChildrenId(1, ntic.getId());
            }
        }
        newModel.setMatrix(((SimpleTreeFrame)this.viewer).getMatrix());
        newModel.setInstances(inst);
        newModel.setAlpha(model.getAlpha());
        newModel.setColortable(model.getColorTable());
        newModel.setType(model.getType());
        SimpleTreeConnectivity conn = model.getSelectedConnectivity();
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        if (conn != null && (edges = conn.getEdges()) != null) {
            for (int i3 = 0; i3 < edges.size(); ++i3) {
                if (!this.isInInstances(instances, edges.get(i3).getSource()) || !this.isInInstances(instances, edges.get(i3).getTarget())) continue;
                newEdges.add(new Edge(edges.get(i3).getSource(), edges.get(i3).getTarget(), edges.get(i3).getWeight()));
            }
        }
        SimpleTreeConnectivity newCon = new SimpleTreeConnectivity(conn.getName(), newEdges);
        ArrayList<Connectivity> conns = newModel.getConnectivities();
        pos = -1;
        for (int i4 = 0; i4 < model.getConnectivities().size(); ++i4) {
            if (!model.getConnectivities().get(i4).equals(conn)) {
                ArrayList<Edge> edges2 = new ArrayList<Edge>();
                for (int j = 0; j < model.getConnectivities().get(i4).getEdges().size(); ++j) {
                    edges2.add(new Edge(model.getConnectivities().get(i4).getEdges().get(i4).getSource(), model.getConnectivities().get(i4).getEdges().get(i4).getTarget()));
                }
                SimpleTreeConnectivity c = new SimpleTreeConnectivity(model.getConnectivities().get(i4).getName(), edges2);
                conns.add(c);
                continue;
            }
            pos = i4;
        }
        if (pos != -1) {
            if (pos == conns.size()) {
                conns.add(newCon);
            } else {
                conns.add(pos, newCon);
            }
        }
        newModel.setSelectedConnectivity(newCon);
        newModel.setInstanceSize(model.getInstanceSize());
        newModel.setImageCollectionPath(model.getImageCollectionPath());
        newModel.setClassMap(model.getClassMap());
        newModel.setMultiscaleParams(model.getMultiscaleParams());
        return newModel;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null) {
            ArrayList<AbstractInstance> instances = new ArrayList<AbstractInstance>();
            if (selinst.size() == 1) {
                instances = TreeSplitSelection.selectHierarchy((SimpleTreeInstance)selinst.get(0));
            } else {
                instances.addAll(selinst);
            }
            SimpleTreeModel newModel = this.getNewModel((SimpleTreeModel)this.viewer.getModel(), instances);
            if (this.viewer instanceof SimpleTreeFrame) {
                SimpleTreeFrame treeFrame = new SimpleTreeFrame();
                treeFrame.setSize(600, 600);
                treeFrame.setDefaultCloseOperation(2);
                treeFrame.setVisible(true);
                treeFrame.setTitle(((SimpleTreeFrame)this.viewer).getTitle() + " (split)");
                treeFrame.setModel(newModel);
                ((SimpleTreeFrame)this.viewer).setSubFrameVariables(treeFrame);
                treeFrame.setClusterData(((SimpleTreeFrame)this.viewer).getClusterData());
                if (this.viewer.getCoordinators() != null) {
                    for (int i = 0; i < this.viewer.getCoordinators().size(); ++i) {
                        treeFrame.addCoordinator(this.viewer.getCoordinators().get(i));
                    }
                }
            }
            selinst.clear();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"));
    }

    @Override
    public String toString() {
        return "Split Tree";
    }
}

