/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.selection;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionModel;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.DATAandBINMultipleFilter;
import simpletree.view.ModelViewer;
import simpletree.view.selection.AbstractSelection;

public class CovarianceSelection
extends AbstractSelection {
    private AbstractMatrix matrix;

    public CovarianceSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (selinst.size() > 0) {
            if (this.matrix == null) {
                try {
                    PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                    int result = OpenDialog.showOpenDialog(spm, new DATAandBINMultipleFilter(), this.viewer.getContainer());
                    if (result == 0) {
                        try {
                            String filename = OpenDialog.getFilename();
                            this.matrix = MatrixFactory.getInstance(filename);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(CovarianceSelection.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CovarianceSelection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.matrix != null) {
                int j;
                int i;
                float[][] points = new float[selinst.size()][];
                HashSet<Integer> selids = new HashSet<Integer>();
                for (int i2 = 0; i2 < selinst.size(); ++i2) {
                    AbstractInstance pi = selinst.get(i2);
                    selids.add(pi.getId());
                    int index = this.matrix.getIds().indexOf(pi.getId());
                    points[i2] = this.matrix.getRow(index).toArray();
                }
                float[] mean = new float[this.matrix.getDimensions()];
                Arrays.fill(mean, 0.0f);
                for (i = 0; i < points.length; ++i) {
                    for (j = 0; j < points[i].length; ++j) {
                        int n = j;
                        mean[n] = mean[n] + points[i][j];
                    }
                }
                i = 0;
                while (i < mean.length) {
                    int n = i++;
                    mean[n] = mean[n] / (float)points.length;
                }
                for (i = 0; i < points.length; ++i) {
                    for (j = 0; j < points[i].length; ++j) {
                        float[] fArray = points[i];
                        int n = j;
                        fArray[n] = fArray[n] - mean[j];
                    }
                }
                float[][] cov = new float[this.matrix.getDimensions() - 1][];
                for (int i3 = 0; i3 < cov.length; ++i3) {
                    cov[i3] = new float[i3 + 1];
                }
                float max = Float.MIN_VALUE;
                float min = Float.MAX_VALUE;
                for (int i4 = 0; i4 < cov.length; ++i4) {
                    for (int j2 = 0; j2 < cov[i4].length; ++j2) {
                        cov[i4][j2] = this.covariance(points, i4 + 1, j2);
                        if (cov[i4][j2] > max) {
                            max = cov[i4][j2];
                        }
                        if (!(cov[i4][j2] < min)) continue;
                        min = cov[i4][j2];
                    }
                }
                System.out.println("Max: " + max);
                System.out.println("Min: " + min);
                DecimalFormat fmt = new DecimalFormat("0.######");
                for (int i5 = 0; i5 < cov.length; ++i5) {
                    for (int j3 = 0; j3 < cov[i5].length; ++j3) {
                        cov[i5][j3] = (cov[i5][j3] - min) / (max - min);
                        System.out.print(fmt.format(cov[i5][j3]) + " ");
                    }
                    System.out.println();
                }
                CovarianceView view = new CovarianceView();
                view.display(cov);
            }
            if (this.viewer.getModel() != null) {
                this.viewer.getModel().setSelectedInstances(selinst);
                this.viewer.getModel().notifyObservers();
            }
        }
    }

    private float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)points.length;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/table/RowInsertBefore16.gif"));
    }

    @Override
    public String toString() {
        return "Covariance Selection";
    }

    class CovarianceView
    extends ApplicationFrame {
        private ViewPanel view;
        private float[][] covMatrix;

        public CovarianceView() {
            super("Covariance View");
            this.view = null;
            this.covMatrix = null;
        }

        public void display(float[][] matrix) {
            this.setSize(500, 500);
            this.view = new ViewPanel();
            this.view.setPreferredSize(new Dimension(500, 300));
            this.setContentPane(this.view);
            this.pack();
            this.covMatrix = matrix;
            RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
            this.setVisible(true);
            this.setDefaultCloseOperation(2);
        }

        private void draw(BufferedImage image) {
            int j;
            int i;
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            int x0 = 10;
            int y0 = 10;
            int dist = 20;
            for (i = 0; i < this.covMatrix.length; ++i) {
                for (j = 0; j < this.covMatrix[i].length; ++j) {
                    g2.setColor(((ProjectionModel)CovarianceSelection.this.viewer.getModel()).getColorTable().getColor(this.covMatrix[i][j]));
                    g2.fillRect(x0 + j * dist, y0 + (i + 1) * dist, dist, dist);
                    g2.fillRect(x0 + (i + 1) * dist, y0 + j * dist, dist, dist);
                }
            }
            g2.setColor(((ProjectionModel)CovarianceSelection.this.viewer.getModel()).getColorTable().getColor(0.0f));
            for (i = 0; i <= this.covMatrix.length; ++i) {
                j = i;
                g2.fillRect(x0 + j * dist, y0 + i * dist, dist, dist);
            }
            g2.setColor(Color.BLACK);
            for (i = 0; i < this.covMatrix.length; ++i) {
                g2.drawLine(x0, y0 + (i + 1) * dist, x0 + (this.covMatrix.length + 1) * dist, y0 + (i + 1) * dist);
                g2.drawLine(x0 + (i + 1) * dist, y0, x0 + (i + 1) * dist, y0 + (this.covMatrix.length + 1) * dist);
            }
        }

        public void windowClosing(WindowEvent evt) {
            if (evt.getWindow() == this) {
                this.dispose();
            }
        }

        public class ViewPanel
        extends JPanel {
            private BufferedImage image = null;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponents(g);
                Graphics2D g2 = (Graphics2D)g;
                if (this.image == null) {
                    Dimension size = this.getSize();
                    this.image = new BufferedImage(size.width + 10, size.height + 10, 1);
                    System.out.println(size.width);
                    System.out.println(size.height);
                    Graphics2D g2Buffer = this.image.createGraphics();
                    g2Buffer.setColor(Color.WHITE);
                    g2Buffer.fillRect(0, 0, size.width + 10, size.height + 10);
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    CovarianceView.this.draw(this.image);
                    g2Buffer.dispose();
                }
                if (this.image != null) {
                    g2.drawImage((Image)this.image, 0, 0, null);
                }
            }
        }
    }
}

