/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.selection;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import simpletree.basics.color.ColorScaleFactory;
import simpletree.basics.color.DynamicScale;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;
import simpletree.view.ModelViewer;
import simpletree.view.selection.AbstractSelection;

public class DynamicColorSelection
extends AbstractSelection {
    private Color color;

    public DynamicColorSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null && selinst.size() > 0) {
            this.color = JColorChooser.showDialog(this.viewer.getContainer(), "Choose a color", Color.RED);
            if (this.color != null) {
                ((ProjectionModel)this.viewer.getModel()).changeColorScaleType(ColorScaleFactory.ColorScaleType.DYNAMIC_SCALE);
                DynamicScale cScale = (DynamicScale)((ProjectionModel)this.viewer.getModel()).getColorTable().getColorScale();
                int index = cScale.addColor(this.color);
                ArrayList<Scalar> scalars = ((ProjectionModel)this.viewer.getModel()).getScalars();
                int i = 0;
                while (!scalars.get(i).getName().equals("dynamic color")) {
                    ++i;
                }
                Scalar dynScalar = ((ProjectionModel)this.viewer.getModel()).getScalars().get(i);
                for (AbstractInstance ai : selinst) {
                    ((ProjectionInstance)ai).setScalarValue(dynScalar, index);
                }
                ((ProjectionModel)this.viewer.getModel()).setSelectedScalar(dynScalar);
                this.viewer.getModel().setSelectedInstances(selinst);
                this.viewer.getModel().notifyObservers();
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/development/WebComponent16.gif"));
    }

    @Override
    public String toString() {
        return "Dynamic Color Selection";
    }

    public Color getColor() {
        return this.color;
    }
}

