/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.selection;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.YIntervalRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.DATAandBINMultipleFilter;
import simpletree.view.ModelViewer;
import simpletree.view.ProjectionFrame;
import simpletree.view.selection.AbstractSelection;

public class RangeSelection
extends AbstractSelection {
    private AbstractMatrix matrix;

    public RangeSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (selinst.size() > 0) {
            if (this.matrix == null) {
                try {
                    PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                    int result = OpenDialog.showOpenDialog(spm, new DATAandBINMultipleFilter(), this.viewer.getContainer());
                    if (result == 0) {
                        try {
                            String filename = OpenDialog.getFilename();
                            this.matrix = MatrixFactory.getInstance(filename);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(RangeSelection.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(RangeSelection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.matrix != null) {
                MinMax[] selranges = new MinMax[this.matrix.getDimensions()];
                MinMax[] dataranges = new MinMax[this.matrix.getDimensions()];
                for (int i = 0; i < selranges.length; ++i) {
                    selranges[i] = new MinMax();
                    dataranges[i] = new MinMax();
                }
                HashSet<Integer> selids = new HashSet<Integer>();
                for (AbstractInstance pi : selinst) {
                    selids.add(pi.getId());
                }
                for (int i = 0; i < this.matrix.getRowCount(); ++i) {
                    int j;
                    AbstractVector row = this.matrix.getRow(i);
                    float[] array = row.toArray();
                    if (selids.contains(row.getId())) {
                        for (j = 0; j < array.length; ++j) {
                            selranges[j].store(array[j]);
                        }
                    }
                    for (j = 0; j < array.length; ++j) {
                        dataranges[j].store(array[j]);
                    }
                }
                if (this.viewer.getModel() != null) {
                    Scalar rangescalar = ((ProjectionModel)this.viewer.getModel()).addScalar("range");
                    ArrayList<AbstractInstance> instances = this.viewer.getModel().getInstances();
                    for (int i = 0; i < instances.size(); ++i) {
                        ((ProjectionInstance)instances.get(i)).setScalarValue(rangescalar, this.calculateScalar(this.matrix.getRow(i), selranges));
                    }
                    if (this.viewer instanceof ProjectionFrame) {
                        ((ProjectionFrame)this.viewer).updateScalars(rangescalar);
                    }
                }
                RangeView view = new RangeView();
                view.display(selranges, dataranges);
            }
            if (this.viewer.getModel() != null) {
                this.viewer.getModel().setSelectedInstances(selinst);
                this.viewer.getModel().notifyObservers();
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/table/ColumnDelete16.gif"));
    }

    @Override
    public String toString() {
        return "Range Selection";
    }

    private float calculateScalar(AbstractVector v, MinMax[] ranges) {
        float[] array = v.toArray();
        float scalar = 0.0f;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] > ranges[i].max || array[i] < ranges[i].min) {
                return 0.0f;
            }
            scalar += Math.abs(array[i] - (ranges[i].max + ranges[i].min) / 2.0f);
        }
        return -scalar;
    }

    class RangeView
    extends ApplicationFrame {
        public RangeView() {
            super("Range View");
        }

        public void display(MinMax[] selranges, MinMax[] dataranges) {
            ChartPanel panel = new ChartPanel(this.createChart(this.createDataset(selranges, dataranges)));
            panel.setPreferredSize(new Dimension(500, 300));
            this.setContentPane((Container)panel);
            this.pack();
            RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
            this.setVisible(true);
            this.setDefaultCloseOperation(2);
        }

        private JFreeChart createChart(IntervalXYDataset intervalxydataset) {
            JFreeChart jfreechart = ChartFactory.createScatterPlot((String)"", (String)"Attribute", (String)"Range", (XYDataset)intervalxydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            jfreechart.setBackgroundPaint((Paint)Color.white);
            XYPlot xyplot = (XYPlot)jfreechart.getPlot();
            xyplot.setBackgroundPaint((Paint)Color.lightGray);
            xyplot.setDomainGridlinePaint((Paint)Color.white);
            xyplot.setRangeGridlinePaint((Paint)Color.white);
            xyplot.setAxisOffset(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
            xyplot.setRenderer((XYItemRenderer)new YIntervalRenderer());
            return jfreechart;
        }

        private IntervalXYDataset createDataset(MinMax[] selranges, MinMax[] dataranges) {
            YIntervalSeriesCollection seriescollection = new YIntervalSeriesCollection();
            YIntervalSeries selseries = new YIntervalSeries((Comparable)((Object)"Selection"));
            for (int i = 0; i < selranges.length; ++i) {
                selseries.add((double)(i + 1), 0.0, (double)((selranges[i].min - dataranges[i].min) / (dataranges[i].max - dataranges[i].min)), (double)((selranges[i].max - dataranges[i].min) / (dataranges[i].max - dataranges[i].min)));
            }
            seriescollection.addSeries(selseries);
            YIntervalSeries dataseries = new YIntervalSeries((Comparable)((Object)"Data set"));
            for (int i = 0; i < dataranges.length; ++i) {
                dataseries.add((double)(i + 1), 0.0, 0.0, 1.0);
            }
            seriescollection.addSeries(dataseries);
            return seriescollection;
        }

        public void windowClosing(WindowEvent evt) {
            if (evt.getWindow() == this) {
                this.dispose();
            }
        }
    }

    public class MinMax {
        private float min = Float.MAX_VALUE;
        private float max = Float.MIN_VALUE;

        public void store(float value) {
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
        }

        public float min() {
            return this.min;
        }

        public float max() {
            return this.max;
        }

        public String toString() {
            return "(" + this.min + "," + this.max + ")";
        }
    }
}

