/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import simpletree.datamining.clustering.SilhouetteCoefficient;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;
import simpletree.util.ProjectionUtil;

public class SilhouetteCoefficientView
extends JDialog {
    private ProjectionModel model;
    private AbstractMatrix matrix;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel2;
    private JButton closeButton;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton generateButton;
    private JScrollPane resultScrollPane;
    private JTextArea resultTextArea;
    private JCheckBox scalarCheckBox;
    private JPanel scalarPanel;

    private SilhouetteCoefficientView(Frame parent) {
        super(parent);
        this.initComponents();
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.distanceComboBox.addItem(disstype);
        }
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.resultScrollPane = new JScrollPane();
        this.resultTextArea = new JTextArea();
        this.scalarPanel = new JPanel();
        this.scalarCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Calculate the Silhouette");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.dataPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.resultScrollPane.setBorder(BorderFactory.createTitledBorder("Result"));
        this.resultTextArea.setColumns(40);
        this.resultTextArea.setRows(8);
        this.resultScrollPane.setViewportView(this.resultTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.resultScrollPane, gridBagConstraints);
        this.scalarPanel.setBorder(BorderFactory.createTitledBorder("Scalar"));
        this.scalarCheckBox.setSelected(true);
        this.scalarCheckBox.setText("Create scalars");
        this.scalarPanel.add(this.scalarCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.scalarPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SilhouetteCoefficientView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SilhouetteCoefficientView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.model != null && this.matrix != null) {
                DissimilarityFactory.DissimilarityType mtype = (DissimilarityFactory.DissimilarityType)((Object)this.distanceComboBox.getSelectedItem());
                AbstractDissimilarity diss = DissimilarityFactory.getInstance(mtype);
                SilhouetteCoefficient sc = new SilhouetteCoefficient();
                float[] silhouette = sc.execute(this.matrix, diss);
                float average = sc.average(silhouette);
                this.resultTextArea.append("Silhouette coefficient: " + average + "\r\n");
                this.resultTextArea.append("---\r\n");
                if (this.scalarCheckBox.isSelected()) {
                    this.createScalars(silhouette);
                }
            } else {
                JOptionPane.showMessageDialog(this, "A projection must be provided.", "Error", 0);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static SilhouetteCoefficientView getInstance(JFrame parent) {
        return new SilhouetteCoefficientView(parent);
    }

    public void display(ProjectionModel model, Scalar scalar) throws IOException {
        this.model = model;
        this.matrix = ProjectionUtil.modelToMatrix(model, scalar);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void createScalars(float[] silhouette) throws IOException {
        int i;
        int i2;
        for (int i3 = 0; i3 < silhouette.length; ++i3) {
            silhouette[i3] = (silhouette[i3] + 1.0f) / 2.0f;
        }
        float[] cdata = this.matrix.getClassData();
        ArrayList<Float> cdata_index = new ArrayList<Float>();
        for (int i4 = 0; i4 < cdata.length; ++i4) {
            if (cdata_index.contains(Float.valueOf(cdata[i4]))) continue;
            cdata_index.add(Float.valueOf(cdata[i4]));
        }
        int[] cluster_id = new int[cdata.length];
        for (int i5 = 0; i5 < cdata.length; ++i5) {
            int index;
            cluster_id[i5] = index = cdata_index.indexOf(Float.valueOf(cdata[i5]));
        }
        float[] clsilhaverage = new float[cdata_index.size()];
        int[] nrel = new int[cdata_index.size()];
        Arrays.fill(nrel, 0);
        Arrays.fill(clsilhaverage, 0.0f);
        for (int i6 = 0; i6 < cdata.length; ++i6) {
            int index;
            int n = index = cdata_index.indexOf(Float.valueOf(cdata[i6]));
            clsilhaverage[n] = clsilhaverage[n] + silhouette[i6];
            int n2 = index;
            nrel[n2] = nrel[n2] + 1;
        }
        float[] clsilhouette = new float[cdata.length];
        for (int i7 = 0; i7 < cdata.length; ++i7) {
            int index = cdata_index.indexOf(Float.valueOf(cdata[i7]));
            clsilhouette[i7] = clsilhaverage[index] / (float)nrel[index];
        }
        float[] normsilhouette = new float[silhouette.length];
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (i2 = 0; i2 < silhouette.length; ++i2) {
            if (max < silhouette[i2]) {
                max = silhouette[i2];
            }
            if (!(min > silhouette[i2])) continue;
            min = silhouette[i2];
        }
        for (i2 = 0; i2 < silhouette.length; ++i2) {
            normsilhouette[i2] = (silhouette[i2] - min) / (max - min);
        }
        float[] normclsilhouette = new float[silhouette.length];
        max = Float.NEGATIVE_INFINITY;
        min = Float.POSITIVE_INFINITY;
        for (i = 0; i < clsilhouette.length; ++i) {
            if (max < clsilhouette[i]) {
                max = clsilhouette[i];
            }
            if (!(min > clsilhouette[i])) continue;
            min = clsilhouette[i];
        }
        for (i = 0; i < clsilhouette.length; ++i) {
            normclsilhouette[i] = (clsilhouette[i] - min) / (max - min);
        }
        Scalar silh = this.model.addScalar("silhouette");
        Scalar nsilh = this.model.addScalar("normalized silhouette");
        Scalar clsilh = this.model.addScalar("cluster silhouette");
        Scalar nclsilh = this.model.addScalar("normalized cluster silhouette");
        ArrayList<AbstractInstance> instances = this.model.getInstances();
        for (int i8 = 0; i8 < instances.size(); ++i8) {
            ProjectionInstance pi = (ProjectionInstance)instances.get(i8);
            pi.setScalarValue(silh, silhouette[i8]);
            pi.setScalarValue(nsilh, normsilhouette[i8]);
            pi.setScalarValue(clsilh, clsilhouette[i8]);
            pi.setScalarValue(nclsilh, normclsilhouette[i8]);
        }
    }
}

