/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simpletree.model.SimpleTreeModel;

public class TreePartialViewParamView
extends JDialog {
    private int treeLevels = -1;
    private ButtonResult pressedButton;
    private SimpleTreeModel simpleTreeModel;
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JPanel mainPanel;
    private JLabel markAlphaLabel;
    private JButton okButton;
    private JSlider opacityMarkSlider;
    private JSpinner treeLevelSpinner;
    private JLabel treeLevelsLabel;

    public TreePartialViewParamView(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void show(SimpleTreeModel model) {
        this.simpleTreeModel = model;
        JComponent editor = this.treeLevelSpinner.getEditor();
        JFormattedTextField spinnerTextField = ((JSpinner.DefaultEditor)editor).getTextField();
        this.setVisible(true);
        if (this.pressedButton.equals((Object)ButtonResult.OK)) {
            // empty if block
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.treeLevelsLabel = new JLabel();
        this.treeLevelSpinner = new JSpinner();
        this.markAlphaLabel = new JLabel();
        this.opacityMarkSlider = new JSlider();
        this.bottomPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Multiscale Tree Parameters");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder("Partial Tree View Parameters"));
        this.mainPanel.setLayout(new GridBagLayout());
        this.treeLevelsLabel.setText("Displayed Tree Levels:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.treeLevelsLabel, gridBagConstraints);
        this.treeLevelSpinner.setModel(new SpinnerNumberModel((Number)5, Integer.valueOf(1), null, (Number)1));
        this.treeLevelSpinner.setToolTipText("Select the displayed levels of the tree");
        this.treeLevelSpinner.setPreferredSize(new Dimension(35, 20));
        this.treeLevelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreePartialViewParamView.this.treeLevelSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.treeLevelSpinner, gridBagConstraints);
        this.markAlphaLabel.setText("Mark opacity:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.markAlphaLabel, gridBagConstraints);
        this.opacityMarkSlider.setValue(80);
        this.opacityMarkSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreePartialViewParamView.this.opacityMarkSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.opacityMarkSlider, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePartialViewParamView.this.okButtonActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePartialViewParamView.this.cancelButtonActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 416) / 2, (screenSize.height - 338) / 2, 416, 338);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.pressedButton = ButtonResult.OK;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.pressedButton = ButtonResult.CANCEL;
        this.setVisible(false);
    }

    private void treeLevelSpinnerStateChanged(ChangeEvent evt) {
        String levels = this.treeLevelSpinner.getModel().getValue().toString();
    }

    private void opacityMarkSliderStateChanged(ChangeEvent evt) {
        float markOpacity = (float)this.opacityMarkSlider.getValue() / 100.0f;
        this.simpleTreeModel.setChanged();
        this.simpleTreeModel.notifyObservers();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TreePartialViewParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TreePartialViewParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TreePartialViewParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TreePartialViewParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePartialViewParamView view = new TreePartialViewParamView(null, true);
                view.setDefaultCloseOperation(2);
                view.setVisible(true);
            }
        });
    }

    public int getTreeLevels() {
        return this.treeLevels;
    }

    public void setTreeLevels(int treeLevels) {
        this.treeLevels = treeLevels;
    }

    private static enum ButtonResult {
        OK,
        CANCEL;

    }
}

