/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.basic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mesh2d.basic.Element;
import mesh2d.graph.Edge;

public class Cell
extends Element {
    private final List<Edge> edges;
    private final Polygon shape;
    private Image background;
    private float backgroundAlpha = 0.5f;

    public Cell(int siteId, List<Edge> edges) {
        super(siteId);
        this.edges = edges;
        int[] x = new int[edges.size() + 1];
        int[] y = new int[edges.size() + 1];
        for (int i = 0; i < edges.size(); ++i) {
            x[i] = (int)edges.get(i).getSource().getX();
            y[i] = (int)edges.get(i).getSource().getY();
        }
        x[edges.size()] = (int)edges.get(edges.size() - 1).getTarget().getX();
        y[edges.size()] = (int)edges.get(edges.size() - 1).getTarget().getY();
        this.shape = new Polygon(x, y, edges.size());
    }

    public boolean contains(int x, int y) {
        return this.getShape().contains(new Point(x, y));
    }

    public void paint(Graphics2D g2, boolean highQualityRender) {
        g2 = (Graphics2D)g2.create();
        if (highQualityRender) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setColor(this.color);
        g2.fillPolygon(this.getShape());
        if (this.background != null) {
            this.paintBackground(g2);
        }
    }

    public void paintBackground(Graphics2D g2) {
        Rectangle shapeBounds = this.getShape().getBounds();
        g2 = (Graphics2D)g2.create();
        if (!this.selected) {
            g2.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
        } else {
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        try {
            this.background = this.getScaledImage((BufferedImage)this.background, shapeBounds.width, shapeBounds.height);
            g2.setClip(this.getShape());
            g2.drawImage(this.background, shapeBounds.x, shapeBounds.y, null);
        }
        catch (Exception e) {
            Logger.getLogger(Cell.class.getName()).log(Level.SEVERE, e.getMessage());
        }
    }

    public Image getBackground() {
        return this.background;
    }

    public void setBackground(Image background) {
        this.background = background;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Point getCenter() {
        if (this.getShape() == null) {
            return null;
        }
        int x = (this.getShape().getBounds().x + this.getShape().getBounds().width) / 2;
        int y = (this.getShape().getBounds().y + this.getShape().getBounds().height) / 2;
        return new Point(x, y);
    }

    private BufferedImage getScaledImage(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
        return bilinearScaleOp.filter(image, new BufferedImage(width, height, image.getType()));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
    }

    public Polygon getShape() {
        return this.shape;
    }
}

