/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.graph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import mesh2d.basic.Element;

public class Vertex
extends Element
implements Cloneable {
    private double x;
    private double y;
    private boolean valid = false;

    public Vertex() {
        this.id = -1;
        this.alpha = 1.0f;
        this.color = Color.RED;
        this.valid = false;
        this.selected = false;
    }

    public Vertex(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public Vertex(int id, double x, double y) {
        this();
        this.x = x;
        this.y = y;
        this.id = id;
    }

    public Vertex(Point2D.Float p) {
        this();
        this.x = p.x;
        this.y = p.y;
    }

    public Vertex clone() throws CloneNotSupportedException {
        super.clone();
        Vertex v = new Vertex(this.getId(), this.x, this.y);
        v.setAlpha(this.alpha);
        v.setColor(this.color);
        return v;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public float distanceTo(Vertex a) {
        double distance = Math.sqrt(Math.pow(this.getX() - a.getX(), 2.0) + Math.pow(this.getY() - a.getY(), 2.0));
        return (float)distance;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    public void paint(Graphics2D g2) {
        Composite oldComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setColor(this.color);
        g2.fillOval((int)this.x, (int)this.y, 4, 4);
        g2.setComposite(oldComposite);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex ref = (Vertex)o;
        if (ref.getId() != this.getId()) {
            return false;
        }
        return (int)ref.x == (int)this.x && (int)ref.y == (int)this.y;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        return hash;
    }

    public String toString() {
        return this.id + " -> (" + (int)this.x + "," + (int)this.y + ")";
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

