/*
 * Decompiled with CFR 0.152.
 */
package lspsolver;

import java.io.IOException;
import java.util.ArrayList;

public class Solver {
    private ArrayList<Integer> indexes_a_lin;
    private ArrayList<Integer> indexes_a_col;
    private ArrayList<Float> values_a;
    private ArrayList<Integer> indexes_b_lin;
    private ArrayList<Integer> indexes_b_col;
    private ArrayList<Float> values_b;
    private int nrlines;
    private int nrcol;

    public Solver(int nrlines, int nrcol) {
        this.nrlines = nrlines;
        this.nrcol = nrcol;
        this.indexes_a_lin = new ArrayList();
        this.indexes_a_col = new ArrayList();
        this.values_a = new ArrayList();
        this.indexes_b_lin = new ArrayList();
        this.indexes_b_col = new ArrayList();
        this.values_b = new ArrayList();
    }

    public void addToA(int lin, int col, float value) throws IOException {
        if (lin >= this.nrlines || col >= this.nrcol) {
            throw new IOException("Index (" + lin + "," + col + ") not valid for matrix A.");
        }
        this.indexes_a_lin.add(lin);
        this.indexes_a_col.add(col);
        this.values_a.add(Float.valueOf(value));
    }

    public void addToB(int lin, int col, float value) throws IOException {
        if (lin >= this.nrlines || col >= 3) {
            throw new IOException("Index (" + lin + "," + col + ") not valid for matrix B.");
        }
        this.indexes_b_lin.add(lin);
        this.indexes_b_col.add(col);
        this.values_b.add(Float.valueOf(value));
    }

    public float[] solve() {
        int[] indexes_a_aux = new int[this.indexes_a_lin.size() + this.indexes_a_col.size()];
        float[] values_a_aux = new float[this.values_a.size()];
        for (int i = 0; i < indexes_a_aux.length; i += 2) {
            indexes_a_aux[i] = this.indexes_a_lin.get(i / 2);
            indexes_a_aux[i + 1] = this.indexes_a_col.get(i / 2);
            values_a_aux[i / 2] = this.values_a.get(i / 2).floatValue();
        }
        this.indexes_a_lin = null;
        this.indexes_a_col = null;
        this.values_a = null;
        int[] indexes_b_aux = new int[this.indexes_b_lin.size() + this.indexes_b_col.size()];
        float[] values_b_aux = new float[this.values_b.size()];
        for (int i = 0; i < indexes_b_aux.length; i += 2) {
            indexes_b_aux[i] = this.indexes_b_lin.get(i / 2);
            indexes_b_aux[i + 1] = this.indexes_b_col.get(i / 2);
            values_b_aux[i / 2] = this.values_b.get(i / 2).floatValue();
        }
        this.indexes_b_lin = null;
        this.indexes_b_col = null;
        this.values_b = null;
        return this.solve(indexes_a_aux, values_a_aux, indexes_b_aux, values_b_aux, this.nrlines, this.nrcol);
    }

    private native float[] solve(int[] var1, float[] var2, int[] var3, float[] var4, int var5, int var6);

    static {
        System.loadLibrary("lspsolver");
    }
}

