/*
 * Decompiled with CFR 0.152.
 */
package simpletree.basics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.MultiscaleParams;
import simpletree.basics.NewickTree;
import simpletree.layout.radial.RadialLayoutComp;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeModelComp;
import simpletree.model.content.LabelContent;
import simpletree.model.newick.NewickNode;
import simpletree.model.newick.NewickUtils;
import simpletree.technique.packagenj.PackageNJConnectionComp;
import simpletree.util.Util;
import simpletree.view.SimpleTreeFrameComp;

public class SimpleTree {
    private String type;
    private ArrayList<ContentSimpleTree> nodes = new ArrayList();
    private ArrayList<Edge> edges = new ArrayList();
    private MultiscaleParams multiScaleParams;
    private LabelContent labels;
    private HashMap<Integer, String> labelMap;
    private HashMap<Integer, Float> classMap;

    public SimpleTree() {
        this.labelMap = new HashMap();
        this.classMap = new HashMap();
    }

    public SimpleTree(String newickTree) {
        NewickNode root = NewickUtils.parse(newickTree);
        Stack<NewickNode> nodeStack = new Stack<NewickNode>();
        nodeStack.push(root);
        NewickNode node = null;
        while (!nodeStack.isEmpty()) {
            node = (NewickNode)nodeStack.pop();
            int id = Util.isParsableToInt(node.id) ? Integer.valueOf(node.id) : Util.convertToInt(node.id);
            ContentSimpleTree stNode = new ContentSimpleTree(id);
            stNode.setLevel(node.level);
            if (node.parent != null) {
                int parentId = Util.isParsableToInt(node.parent.id) ? Integer.valueOf(node.parent.id) : Util.convertToInt(node.parent.id);
                stNode.setParent(parentId);
            }
            this.nodes.add(stNode);
            if (node.children.isEmpty()) {
                stNode.setValid(true);
                continue;
            }
            stNode.setValid(false);
            for (int i = 0; i < node.children.size(); ++i) {
                NewickNode child = node.children.get(i);
                int childId = Util.isParsableToInt(child.id) ? Integer.valueOf(child.id) : Util.convertToInt(child.id);
                ContentSimpleTree stChild = new ContentSimpleTree(childId);
                stChild.setParent(id);
                stChild.setLevel(child.level);
                stNode.addChildren(childId, node.distChildren.get(i).floatValue());
                this.edges.add(new Edge(id, childId, node.distChildren.get(i).floatValue()));
                if (!child.children.isEmpty()) {
                    nodeStack.push(child);
                    continue;
                }
                this.nodes.add(stChild);
            }
        }
    }

    public HashMap<Integer, String> getLabelMap() {
        return this.labelMap;
    }

    public void setLabelMap(HashMap<Integer, String> labelMap) {
        this.labelMap = labelMap;
    }

    public HashMap<Integer, Float> getClassMap() {
        return this.classMap;
    }

    public void setClassMap(HashMap<Integer, Float> classMap) {
        this.classMap = classMap;
    }

    private void convertToTree(NewickTree nw) {
        this.getTree(nw, nw);
    }

    private ContentSimpleTree getTree(NewickTree nw, NewickTree root) {
        if (nw != null) {
            int id = Util.isParsableToInt(nw.name) ? Integer.parseInt(nw.name) : Util.convertToInt(nw.name);
            ContentSimpleTree ct = new ContentSimpleTree(id);
            this.nodes.add(0, ct);
            if (nw.left != null) {
                ct.setValid(false);
                ContentSimpleTree left = this.getTree(nw.left, root);
                left.setParent(ct.getId());
                ct.setChildrenId(0, left.getId());
                ct.setDistChildren(0, root.getDistParent(nw.left.name, root));
                ContentSimpleTree right = this.getTree(nw.right, root);
                right.setParent(ct.getId());
                ct.setChildrenId(1, right.getId());
                ct.setDistChildren(1, root.getDistParent(nw.right.name, root));
                if (left.getLevel() > right.getLevel()) {
                    ct.setLevel(left.getLevel() + 1);
                } else {
                    ct.setLevel(right.getLevel() + 1);
                }
            } else {
                ct.setLevel(0);
            }
            return ct;
        }
        return null;
    }

    public SimpleTree clone() {
        SimpleTree ntree = new SimpleTree();
        ntree.type = this.type;
        ntree.nodes = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            ContentSimpleTree n = this.nodes.get(i);
            ContentSimpleTree p = n.clone();
            ntree.nodes.add(p);
        }
        ntree.edges = new ArrayList();
        ntree.edges.addAll(this.edges);
        return ntree;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean appendTree(SimpleTree refTree, int intoNodeId, boolean checkIds) {
        if (checkIds) {
            int maxNodeId = this.getMaxNodeId() + 1;
            for (ContentSimpleTree refNode : refTree.nodes) {
                if (refNode.isValid()) continue;
                refTree.replaceNodeId(refNode.getId(), maxNodeId);
                ++maxNodeId;
            }
        }
        int refRootId = refTree.getRootId();
        ContentSimpleTree refRootNode = refTree.getNodeById(refRootId);
        ContentSimpleTree intoNode = this.getNodeById(intoNodeId);
        ContentSimpleTree parentNode = this.getNodeById(intoNode.getParent());
        refRootNode.setParent(parentNode.getId());
        int intoNodeIndex = parentNode.getChildrenIndex(intoNodeId);
        parentNode.setChildrenId(intoNodeIndex, refRootId);
        intoNode.setParent(-1);
        this.removeSubTree(intoNode);
        this.nodes.addAll(refTree.nodes);
        return true;
    }

    public void replaceNodeId(int nodeId, int newNodeId) {
        ContentSimpleTree node = this.getNodeById(nodeId);
        if (node.getParent() != -1) {
            ContentSimpleTree parentNode = this.getNodeById(node.getParent());
            for (int i = 0; i < parentNode.getNumChildren(); ++i) {
                int childId = parentNode.getChildrenId(i);
                if (childId != node.getId()) continue;
                parentNode.setChildrenId(i, newNodeId);
                break;
            }
        }
        System.out.println("Replacing node id " + node.getId());
        if (node.hasChildren()) {
            for (int i = 0; i < node.getNumChildren(); ++i) {
                int childId = node.getChildrenId(i);
                ContentSimpleTree currentChildren = this.getNodeById(childId);
                currentChildren.setParent(newNodeId);
            }
        }
        node.setId(newNodeId);
    }

    public void replaceAllNodeIds(int seedId) {
        int rootId = this.getRootId();
        ContentSimpleTree rootNode = this.getNodeById(rootId);
        Stack<ContentSimpleTree> nodeStack = new Stack<ContentSimpleTree>();
        ContentSimpleTree currentNode = rootNode;
        while (currentNode != null) {
            if (currentNode.getParent() != -1) {
                ContentSimpleTree parentNode = this.getNodeById(currentNode.getParent());
                for (int i = 0; i < parentNode.getNumChildren(); ++i) {
                    int childId = parentNode.getChildrenId(i);
                    if (childId != currentNode.getId()) continue;
                    parentNode.setChildrenId(i, seedId);
                    break;
                }
            }
            currentNode.setId(seedId);
            ++seedId;
            if (currentNode.hasChildren()) {
                for (int i = 0; i < currentNode.getNumChildren(); ++i) {
                    int childId = currentNode.getChildrenId(i);
                    ContentSimpleTree currentChildren = this.getNodeById(childId);
                    currentChildren.setParent(currentNode.getId());
                    nodeStack.push(currentChildren);
                }
            }
            if (nodeStack.isEmpty()) {
                currentNode = null;
                continue;
            }
            currentNode = (ContentSimpleTree)nodeStack.pop();
        }
    }

    public int getMaxNodeId() {
        int maxNodeId = Integer.MIN_VALUE;
        for (ContentSimpleTree node : this.nodes) {
            if (maxNodeId >= node.getId()) continue;
            maxNodeId = node.getId();
        }
        return maxNodeId;
    }

    public void addNode(ContentSimpleTree node) {
        this.nodes.add(node);
    }

    public void insertNodeAt(int pos, ContentSimpleTree node) {
        this.nodes.add(pos, node);
    }

    public ArrayList<ContentSimpleTree> getNodes() {
        return this.nodes;
    }

    public int getNumberRealNodes() {
        int result = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).isValid()) continue;
            ++result;
        }
        return result;
    }

    public boolean isNode(ContentSimpleTree node) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).equals(node)) continue;
            return true;
        }
        return false;
    }

    public ContentSimpleTree getNode(int index) {
        return this.nodes.get(index);
    }

    public int getNodePosition(ContentSimpleTree node) {
        return this.nodes.indexOf(node);
    }

    public ContentSimpleTree getNodeById(Integer id) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getId() != id.intValue()) continue;
            return this.nodes.get(i);
        }
        return null;
    }

    public void removeSubTree(ContentSimpleTree refNode) {
        ContentSimpleTree parentNode;
        if (refNode.hasChildren()) {
            int childCount = refNode.getNumChildren();
            for (int i = 0; i < childCount; ++i) {
                int childId = refNode.getChildrenId(i);
                ContentSimpleTree childNode = this.getNodeById(childId);
                this.removeSubTree(childNode);
            }
        }
        if ((parentNode = this.getNodeById(refNode.getParent())) != null) {
            parentNode.removeChild(refNode.getId());
        }
        this.nodes.remove(refNode);
    }

    public void removeNode(ContentSimpleTree node) {
        this.nodes.remove(node);
    }

    public int getMaxLevel() {
        int maxLevel = this.nodes.get(0).getLevel();
        for (int i = 1; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getLevel() <= maxLevel) continue;
            maxLevel = this.nodes.get(i).getLevel();
        }
        return maxLevel;
    }

    public int getSize() {
        return this.nodes.size();
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(ArrayList<Edge> edges) {
        this.edges = edges;
    }

    public int getRootId() {
        int id = 0;
        int maxLevel = this.nodes.get(0).getLevel();
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getLevel() < maxLevel) continue;
            maxLevel = this.nodes.get(i).getLevel();
            id = this.nodes.get(i).getId();
        }
        return id;
    }

    private boolean existEdge(int sour, int targ) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if ((this.edges.get(i).getSource() != sour || this.edges.get(i).getTarget() != targ) && (this.edges.get(i).getSource() != targ || this.edges.get(i).getTarget() != sour)) continue;
            return true;
        }
        return false;
    }

    public void generateEdges() {
        this.edges = new ArrayList();
        for (int i = 0; i < this.getSize(); ++i) {
            ContentSimpleTree son = this.getNode(i);
            if (son == null) continue;
            int sonId = son.getId();
            ContentSimpleTree parent = this.getNodeById(son.getParent());
            if (parent == null) continue;
            int srcNode = parent.getId();
            int targetNode = son.getId();
            int ind = parent.getChildrenIndex(son.getId());
            float dis = 0.0f;
            dis = ind != -1 ? parent.getDistChildren(ind) : 1000.0f;
            if (this.existEdge(srcNode, targetNode)) continue;
            this.edges.add(new Edge(srcNode, targetNode, dis));
        }
    }

    public String getNodesString() {
        String ret = "";
        String eol = System.getProperty("line.separator");
        ret = ret + "\n\n--- NODES ---" + eol;
        for (int i = 0; i < this.nodes.size(); ++i) {
            ret = ret + "ID:" + this.nodes.get(i).getId() + ":CLASS:" + this.nodes.get(i).getKlass() + ":NIVEL:" + this.nodes.get(i).getLevel() + ":PARENT:" + this.nodes.get(i).getParent() + " | CHILDREN:";
            if (this.nodes.get(i).hasChildren()) {
                for (int j = 0; j < this.nodes.get(i).getNumChildren(); ++j) {
                    ret = ret + " " + this.nodes.get(i).getChildrenId(j) + "(" + this.nodes.get(i).getDistChildren(j) + ")";
                }
            } else {
                ret = ret + "NONE";
            }
            ret = ret + " " + eol;
        }
        ret = ret + "-------------\n\n";
        return ret;
    }

    public void printNodes() {
        System.out.println(this.getNodesString());
    }

    public void printEdges() {
        System.out.println("\n\n--- EDGES ---");
        for (int i = 0; i < this.edges.size(); ++i) {
            ContentSimpleTree source = this.getNodeById(this.edges.get(i).getSource());
            ContentSimpleTree target = this.getNodeById(this.edges.get(i).getTarget());
            System.out.println("SOURCE : " + source.getId() + " | TARGET : " + target.getId() + " (" + this.edges.get(i).getWeight() + ")");
        }
        System.out.println("-------------\n\n");
    }

    public void save(String filename, String title) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write(this.getNodesString());
        }
        catch (IOException ex) {
            throw new IOException("Problems written \"" + filename + "\"!");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleTree.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private String getXMLNode(ContentSimpleTree ct, int level) {
        String ret = "";
        if (ct.getNumChildren() > 0) {
            ret = ret + "<node label=\"" + ct.getId() + "\">" + System.getProperty("line.separator");
            for (int i = 0; i < ct.getNumChildren(); ++i) {
                ret = ret + this.getXMLNode(this.getNodeById(ct.getChildrenId(i)), level + 1);
            }
            ret = ret + "</node>" + System.getProperty("line.separator");
        } else {
            ret = ret + "<leaf label=\"" + ct.getId() + "\" />" + System.getProperty("line.separator");
        }
        return ret;
    }

    public void saveXML(String output) {
        ContentSimpleTree lroot = this.getNode(this.getSize() - 1);
        if (lroot == null) {
            return;
        }
        String ret = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>" + System.getProperty("line.separator");
        ret = "<tree>" + System.getProperty("line.separator") + this.getXMLNode(lroot, 0) + "</tree>";
        if (output != null && !output.isEmpty()) {
            try {
                if (!output.endsWith(".xml")) {
                    output = output + ".xml";
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(output)));
                bw.write(ret);
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLevels() {
        Stack<ContentSimpleTree> nodeStack = new Stack<ContentSimpleTree>();
        for (ContentSimpleTree node : this.nodes) {
            node.setLevel(0);
            if (node.hasChildren()) continue;
            nodeStack.add(node);
        }
        while (!nodeStack.isEmpty()) {
            ContentSimpleTree currentNode = (ContentSimpleTree)nodeStack.pop();
            int parentNodeId = currentNode.getParent();
            ContentSimpleTree parentNode = this.getNodeById(parentNodeId);
            if (parentNode == null || parentNode.getLevel() >= currentNode.getLevel() + 1) continue;
            parentNode.setLevel(currentNode.getLevel() + 1);
            nodeStack.push(parentNode);
        }
    }

    public void updateRecursiveChildCount() {
        ArrayList<ContentSimpleTree> nodesAux = new ArrayList<ContentSimpleTree>();
        for (ContentSimpleTree node : this.nodes) {
            nodesAux.add(node);
        }
        Collections.sort(nodesAux, new Comparator(){

            public int compare(Object o1, Object o2) {
                ContentSimpleTree node1 = (ContentSimpleTree)o1;
                ContentSimpleTree node2 = (ContentSimpleTree)o2;
                return node1.getLevel() - node2.getLevel();
            }
        });
        for (ContentSimpleTree node : nodesAux) {
            if (this.getNodeById(node.getParent()) == null) continue;
            ContentSimpleTree parent = this.getNodeById(node.getParent());
            int parentRecursiveChildCount = parent.getRecursiveChildCount();
            int nodeRecursiveChildCount = node.getRecursiveChildCount();
            parent.setRecursiveChildCount(parentRecursiveChildCount + nodeRecursiveChildCount + 1);
        }
    }

    public long computeMemoryAmount() {
        long total = 0L;
        total += 96L;
        if (this.type != null && !this.type.isEmpty()) {
            total += (long)(this.type.length() * 16);
        }
        total += 96L;
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                total += this.nodes.get(i).computeMemoryAmount();
            }
        }
        total += 96L;
        if (this.edges != null) {
            total += (long)(this.edges.size() * 224);
        }
        return total;
    }

    public MultiscaleParams getMultiScaleParams() {
        return this.multiScaleParams;
    }

    public void setMultiScaleParams(MultiscaleParams multiScaleParams) {
        this.multiScaleParams = multiScaleParams;
    }

    public LabelContent getLabelContent() {
        return this.labels;
    }

    public void setLabelContent(LabelContent labels) {
        this.labels = labels;
    }

    public static void main(String[] args) throws IOException {
        AbstractMatrix m = MatrixFactory.getInstance("/home/renato/Medical12Classes.data");
        PackageNJConnectionComp stComp = new PackageNJConnectionComp();
        stComp.input(m);
        stComp.setMaxId(1000);
        stComp.execute();
        SimpleTree st = stComp.output();
        SimpleTreeModelComp stModelComp = new SimpleTreeModelComp();
        stModelComp.input(st);
        stModelComp.execute();
        RadialLayoutComp radialComp = new RadialLayoutComp();
        radialComp.input(stModelComp.output());
        radialComp.execute();
        SimpleTreeFrameComp frameComp = new SimpleTreeFrameComp();
        frameComp.input(radialComp.output());
        frameComp.execute();
    }
}

