/*
 * Decompiled with CFR 0.152.
 */
package simpletree.basics.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import simpletree.basics.color.ColorTable;

public class ColorScalePanel
extends JPanel {
    private JLabel maxLabel = new JLabel("Max");
    private JLabel minLabel = new JLabel("Min");
    private ColorScale scale = new ColorScale();
    private ColorTable colorTable;

    public ColorScalePanel(JPanel gv) {
        this.maxLabel.setForeground(Color.GRAY);
        this.maxLabel.setBackground(Color.white);
        this.maxLabel.setFont(new Font("Verdana", 1, 10));
        this.minLabel.setForeground(Color.GRAY);
        this.minLabel.setBackground(Color.white);
        this.minLabel.setFont(new Font("Verdana", 1, 10));
        this.setToolTipText("Click to change the color scale");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.scale, "Center");
        this.add((Component)this.maxLabel, "East");
        this.add((Component)this.minLabel, "West");
        this.addMouseListener(new MouseClickedListener());
    }

    public void setColorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    public class ColorScale
    extends JPanel {
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ColorScalePanel.this.colorTable != null) {
                Dimension size = this.getSize();
                int height = size.height;
                int width = size.width;
                for (int i = 0; i <= width; ++i) {
                    float index = (float)i / (float)width;
                    g.setColor(ColorScalePanel.this.colorTable.getColor(index));
                    g.drawRect(i, 0, i, height);
                    g.fillRect(i, 0, i, height);
                }
            }
        }
    }

    class MouseClickedListener
    extends MouseAdapter {
        MouseClickedListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            super.mouseClicked(evt);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            ColorScalePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            ColorScalePanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

