/*
 * Decompiled with CFR 0.152.
 */
package simpletree.coordination;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import simpletree.basics.color.ColorTable;
import simpletree.coordination.ImagePanel;
import simpletree.util.SaveDialog;
import simpletree.util.filter.PNGFilter;

public class ConfusingMatrixDialog
extends JDialog {
    private ImagePanel imPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton saveImageButton;

    private ConfusingMatrixDialog(JDialog parent) {
        super(parent);
        this.initComponents();
        this.setModal(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Confusion Matrix");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfusingMatrixDialog.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfusingMatrixDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new PNGFilter(), this, "", "ConfusingMatrix.png");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            try {
                if (this.imPanel.imgSave != null) {
                    ImageIO.write((RenderedImage)this.imPanel.imgSave, "png", new File(filename));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ConfusingMatrixDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static ConfusingMatrixDialog getInstance(JDialog parent) {
        return new ConfusingMatrixDialog(parent);
    }

    public void display(TreeMap<Float, HashMap<Float, Integer>> confuseData, ColorTable ct, String label) {
        int tamCell = 30;
        this.imPanel = new ImagePanel(confuseData, label, tamCell);
        this.imPanel.colortable = ct;
        int w = (confuseData.size() + 4) * tamCell;
        int h = (confuseData.size() + 6) * tamCell + 35;
        this.getContentPane().add((Component)this.imPanel, "Center");
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(new Dimension(w, h));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

