/*
 * Decompiled with CFR 0.152.
 */
package simpletree.coordination;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import simpletree.basics.color.ColorTable;

class ImagePanel
extends JPanel {
    private TreeMap<Float, HashMap<Float, Integer>> confuseData;
    public BufferedImage imgSave;
    public ColorTable colortable;
    public String label;
    public int tamCell;

    public ImagePanel(TreeMap<Float, HashMap<Float, Integer>> confuseData, String label, int tamCell) {
        this.confuseData = confuseData;
        this.label = label;
        this.tamCell = tamCell;
    }

    @Override
    public void paintComponent(Graphics g) {
        int ws;
        Color color;
        float normValue;
        float key;
        int xInitial = 20;
        int yInitial = 30;
        int w = (this.confuseData.size() + 3) * this.tamCell;
        int h = (this.confuseData.size() + 3) * this.tamCell + 35;
        this.imgSave = new BufferedImage(w, h, 1);
        Graphics2D g2 = this.imgSave.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, w, h);
        g2.setColor(Color.black);
        Font f = new Font("Arial", 1, 16);
        g2.setFont(f);
        Iterator<Map.Entry<Float, HashMap<Float, Integer>>> it = this.confuseData.entrySet().iterator();
        int l = 0;
        int c = 0;
        FontMetrics metrics = g2.getFontMetrics(g2.getFont());
        String header = "Confusion Matrix";
        g2.drawString(header, (this.imgSave.getWidth() - metrics.stringWidth(header)) / 2, metrics.getAscent() + 3);
        c = 0;
        while (it.hasNext()) {
            Map.Entry<Float, HashMap<Float, Integer>> e = it.next();
            key = e.getKey().floatValue();
            g2.drawRect(xInitial + this.tamCell * (c + 1), yInitial, this.tamCell, this.tamCell);
            normValue = key / this.confuseData.lastKey().floatValue();
            color = this.colortable.getColor(normValue);
            if (color != null) {
                g2.setColor(color);
                g2.fillRect(xInitial + this.tamCell * (c + 1) + 1, yInitial + 1, this.tamCell - 1, this.tamCell - 1);
                g2.setColor(Color.black);
            }
            metrics = g2.getFontMetrics(g2.getFont());
            ws = metrics.stringWidth(Integer.toString(c));
            g2.drawString(Integer.toString((int)key), xInitial + this.tamCell * (c + 1) + (this.tamCell - ws) / 2, yInitial + this.tamCell * l + 22);
            ++c;
        }
        for (Map.Entry<Float, HashMap<Float, Integer>> e : this.confuseData.entrySet()) {
            key = e.getKey().floatValue();
            HashMap<Float, Integer> value = e.getValue();
            f = new Font("Arial", 1, 16);
            g2.setFont(f);
            g2.drawRect(xInitial, yInitial + this.tamCell * (l + 1), this.tamCell, this.tamCell);
            normValue = key / this.confuseData.lastKey().floatValue();
            color = this.colortable.getColor(normValue);
            if (color != null) {
                g2.setColor(color);
                g2.fillRect(xInitial + 1, yInitial + this.tamCell * (l + 1) + 1, this.tamCell - 1, this.tamCell - 1);
                g2.setColor(Color.black);
            }
            metrics = g2.getFontMetrics(g2.getFont());
            ws = metrics.stringWidth(Integer.toString((int)key));
            g2.drawString(Integer.toString((int)key), xInitial + (this.tamCell - ws) / 2, yInitial + this.tamCell * (l + 1) + 22);
            f = new Font("Arial", 0, 13);
            g2.setFont(f);
            Iterator<Map.Entry<Float, HashMap<Float, Integer>>> it2 = this.confuseData.entrySet().iterator();
            c = 0;
            while (it2.hasNext()) {
                Map.Entry<Float, HashMap<Float, Integer>> e2 = it2.next();
                float key2 = e2.getKey().floatValue();
                g2.drawRect(xInitial + this.tamCell * (c + 1), yInitial + this.tamCell * (l + 1), this.tamCell, this.tamCell);
                metrics = g2.getFontMetrics(g2.getFont());
                if (value.containsKey(Float.valueOf(key2))) {
                    ws = metrics.stringWidth(Integer.toString(value.get(Float.valueOf(key2))));
                    g2.drawString(Integer.toString(value.get(Float.valueOf(key2))), xInitial + this.tamCell * (c + 1) + (this.tamCell - ws) / 2, yInitial + this.tamCell * (l + 1) + 20);
                } else {
                    ws = metrics.stringWidth("0");
                    g2.drawString("0", xInitial + this.tamCell * (c + 1) + (this.tamCell - ws) / 2, yInitial + this.tamCell * (l + 1) + 20);
                }
                ++c;
            }
            ++l;
        }
        if (this.label != null && !this.label.trim().isEmpty()) {
            f = new Font("Arial", 0, 13);
            g2.setFont(f);
            metrics = g2.getFontMetrics(g2.getFont());
            g2.setColor(Color.black);
            g2.drawRect((this.imgSave.getWidth() - metrics.stringWidth(this.label)) / 2 - 2, (this.confuseData.size() + 2) * this.tamCell + metrics.getAscent() + 8, metrics.stringWidth(this.label) + 3, metrics.getAscent() + 4);
            g2.drawString(this.label, (this.imgSave.getWidth() - metrics.stringWidth(this.label)) / 2, (this.confuseData.size() + 2) * this.tamCell + 2 * (metrics.getAscent() + 5));
        }
        g.drawImage(this.imgSave, 5, 0, this.imgSave.getWidth(), this.imgSave.getHeight(), null);
    }
}

